/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.inject;

import java.util.ArrayList;
import java.util.List;
import net.devh.boot.grpc.client.inject.GrpcClient;
import org.springframework.beans.factory.config.BeanDefinition;

class GrpcClientConstructorInjection {
    public static final String BEAN_NAME = "grpcClientConstructorInjection";
    private final List<Registry> injections = new ArrayList<Registry>();

    GrpcClientConstructorInjection() {
    }

    public List<Registry> getRegistries() {
        return this.injections;
    }

    public GrpcClientConstructorInjection add(Registry injection) {
        this.injections.add(injection);
        return this;
    }

    public boolean isEmpty() {
        return this.injections.isEmpty();
    }

    static class Registry {
        private final Class<?> stubClazz;
        private final GrpcClient client;
        private final Class<?> targetClazz;
        private final BeanDefinition targetBeanDefinition;
        private final int constructorArgumentIndex;

        public Registry(Class<?> stubClazz, GrpcClient client, Class<?> targetClazz, BeanDefinition targetBeanDefinition, int constructorArgumentIndex) {
            this.stubClazz = stubClazz;
            this.client = client;
            this.targetClazz = targetClazz;
            this.targetBeanDefinition = targetBeanDefinition;
            this.constructorArgumentIndex = constructorArgumentIndex;
        }

        public Class<?> getStubClass() {
            return this.stubClazz;
        }

        public GrpcClient getClient() {
            return this.client;
        }

        public Class<?> getTargetClazz() {
            return this.targetClazz;
        }

        public BeanDefinition getTargetBeanDefinition() {
            return this.targetBeanDefinition;
        }

        public int getConstructorArgumentIndex() {
            return this.constructorArgumentIndex;
        }
    }
}

