/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.otproto;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.ArrayValue;
import io.opentelemetry.proto.common.v1.InstrumentationLibrary;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import java.util.List;

final class CommonAdapter {
    public static KeyValue toProtoAttribute(AttributeKey<?> key, Object value) {
        KeyValue.Builder builder = KeyValue.newBuilder().setKey(key.getKey());
        switch (key.getType()) {
            case STRING: {
                return CommonAdapter.makeStringKeyValue(key, (String)value);
            }
            case BOOLEAN: {
                return CommonAdapter.makeBooleanKeyValue(key, (Boolean)value);
            }
            case LONG: {
                return CommonAdapter.makeLongKeyValue(key, (Long)value);
            }
            case DOUBLE: {
                return CommonAdapter.makeDoubleKeyValue(key, (Double)value);
            }
            case BOOLEAN_ARRAY: {
                return CommonAdapter.makeBooleanArrayKeyValue(key, (List)value);
            }
            case LONG_ARRAY: {
                return CommonAdapter.makeLongArrayKeyValue(key, (List)value);
            }
            case DOUBLE_ARRAY: {
                return CommonAdapter.makeDoubleArrayKeyValue(key, (List)value);
            }
            case STRING_ARRAY: {
                return CommonAdapter.makeStringArrayKeyValue(key, (List)value);
            }
        }
        return builder.setValue(AnyValue.getDefaultInstance()).build();
    }

    private static KeyValue makeLongArrayKeyValue(AttributeKey<?> key, List<Long> value) {
        KeyValue.Builder keyValueBuilder = KeyValue.newBuilder().setKey(key.getKey()).setValue(AnyValue.newBuilder().setArrayValue(CommonAdapter.makeLongArrayAnyValue(value)).build());
        return keyValueBuilder.build();
    }

    private static KeyValue makeDoubleArrayKeyValue(AttributeKey<?> key, List<Double> value) {
        KeyValue.Builder keyValueBuilder = KeyValue.newBuilder().setKey(key.getKey()).setValue(AnyValue.newBuilder().setArrayValue(CommonAdapter.makeDoubleArrayAnyValue(value)).build());
        return keyValueBuilder.build();
    }

    private static KeyValue makeBooleanArrayKeyValue(AttributeKey<?> key, List<Boolean> value) {
        KeyValue.Builder keyValueBuilder = KeyValue.newBuilder().setKey(key.getKey()).setValue(AnyValue.newBuilder().setArrayValue(CommonAdapter.makeBooleanArrayAnyValue(value)).build());
        return keyValueBuilder.build();
    }

    private static KeyValue makeStringArrayKeyValue(AttributeKey<?> key, List<String> value) {
        KeyValue.Builder keyValueBuilder = KeyValue.newBuilder().setKey(key.getKey()).setValue(AnyValue.newBuilder().setArrayValue(CommonAdapter.makeStringArrayAnyValue(value)).build());
        return keyValueBuilder.build();
    }

    private static KeyValue makeLongKeyValue(AttributeKey<?> key, long value) {
        KeyValue.Builder keyValueBuilder = KeyValue.newBuilder().setKey(key.getKey()).setValue(AnyValue.newBuilder().setIntValue(value).build());
        return keyValueBuilder.build();
    }

    private static KeyValue makeDoubleKeyValue(AttributeKey<?> key, double value) {
        KeyValue.Builder keyValueBuilder = KeyValue.newBuilder().setKey(key.getKey()).setValue(AnyValue.newBuilder().setDoubleValue(value).build());
        return keyValueBuilder.build();
    }

    private static KeyValue makeBooleanKeyValue(AttributeKey<?> key, boolean value) {
        KeyValue.Builder keyValueBuilder = KeyValue.newBuilder().setKey(key.getKey()).setValue(AnyValue.newBuilder().setBoolValue(value).build());
        return keyValueBuilder.build();
    }

    private static KeyValue makeStringKeyValue(AttributeKey<?> key, String value) {
        KeyValue.Builder keyValueBuilder = KeyValue.newBuilder().setKey(key.getKey()).setValue(AnyValue.newBuilder().setStringValue(value).build());
        return keyValueBuilder.build();
    }

    private static ArrayValue makeDoubleArrayAnyValue(List<Double> doubleArrayValue) {
        ArrayValue.Builder builder = ArrayValue.newBuilder();
        for (Double doubleValue : doubleArrayValue) {
            builder.addValues(AnyValue.newBuilder().setDoubleValue(doubleValue.doubleValue()).build());
        }
        return builder.build();
    }

    private static ArrayValue makeLongArrayAnyValue(List<Long> longArrayValue) {
        ArrayValue.Builder builder = ArrayValue.newBuilder();
        for (Long intValue : longArrayValue) {
            builder.addValues(AnyValue.newBuilder().setIntValue(intValue.longValue()).build());
        }
        return builder.build();
    }

    private static ArrayValue makeStringArrayAnyValue(List<String> stringArrayValue) {
        ArrayValue.Builder builder = ArrayValue.newBuilder();
        for (String string : stringArrayValue) {
            builder.addValues(AnyValue.newBuilder().setStringValue(string).build());
        }
        return builder.build();
    }

    private static ArrayValue makeBooleanArrayAnyValue(List<Boolean> booleanArrayValue) {
        ArrayValue.Builder builder = ArrayValue.newBuilder();
        for (Boolean bool : booleanArrayValue) {
            builder.addValues(AnyValue.newBuilder().setBoolValue(bool.booleanValue()).build());
        }
        return builder.build();
    }

    static InstrumentationLibrary toProtoInstrumentationLibrary(InstrumentationLibraryInfo instrumentationLibraryInfo) {
        return InstrumentationLibrary.newBuilder().setName(instrumentationLibraryInfo.getName()).setVersion(instrumentationLibraryInfo.getVersion() == null ? "" : instrumentationLibraryInfo.getVersion()).build();
    }

    private CommonAdapter() {
    }
}

