/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.fallback;

import io.apicurio.registry.serde.fallback.FallbackArtifactProvider;
import io.apicurio.registry.serde.strategy.ArtifactReference;
import java.util.Map;
import org.apache.kafka.common.header.Headers;

public class DefaultFallbackArtifactProvider
implements FallbackArtifactProvider {
    private ArtifactReference fallbackArtifactReference;

    @Override
    public void configure(Map<String, Object> configs, boolean isKey) {
        Object groupIdConfigKey = "apicurio.registry.fallback.group-id";
        if (isKey) {
            groupIdConfigKey = (String)groupIdConfigKey + ".key";
        }
        String fallbackGroupId = (String)configs.get(groupIdConfigKey);
        Object artifactIdConfigKey = "apicurio.registry.fallback.artifact-id";
        if (isKey) {
            artifactIdConfigKey = (String)artifactIdConfigKey + ".key";
        }
        String fallbackArtifactId = (String)configs.get(artifactIdConfigKey);
        Object versionConfigKey = "apicurio.registry.fallback.version";
        if (isKey) {
            versionConfigKey = (String)versionConfigKey + ".key";
        }
        String fallbackVersion = (String)configs.get(versionConfigKey);
        if (fallbackArtifactId != null) {
            this.fallbackArtifactReference = ArtifactReference.builder().groupId(fallbackGroupId).artifactId(fallbackArtifactId).version(fallbackVersion).build();
        }
    }

    @Override
    public ArtifactReference get(String topic, Headers headers, byte[] data) {
        return this.fallbackArtifactReference;
    }

    public boolean isConfigured() {
        return this.fallbackArtifactReference != null;
    }
}

