/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.generation.GenerationOutput;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.Role;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

class QwenHelper {
    QwenHelper() {
    }

    static List<Message> toQwenMessages(List<ChatMessage> messages) {
        return messages.stream().map(QwenHelper::toQwenMessage).collect(Collectors.toList());
    }

    static Message toQwenMessage(ChatMessage message) {
        return Message.builder().role(QwenHelper.roleFrom(message)).content(message.text()).build();
    }

    static String roleFrom(ChatMessage message) {
        if (message instanceof AiMessage) {
            return Role.ASSISTANT.getValue();
        }
        if (message instanceof SystemMessage) {
            return Role.SYSTEM.getValue();
        }
        return Role.USER.getValue();
    }

    static String answerFrom(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getMessage).map(Message::getContent).orElseGet(() -> Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getText).orElse(""));
    }

    static TokenUsage tokenUsageFrom(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getUsage).map(usage -> new TokenUsage(usage.getInputTokens(), usage.getOutputTokens())).orElse(new TokenUsage(null, null));
    }

    static FinishReason finishReasonFrom(GenerationResult result) {
        String finishReason;
        switch (finishReason = Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getFinishReason).orElse("")) {
            case "stop": {
                return FinishReason.STOP;
            }
            case "length": {
                return FinishReason.LENGTH;
            }
        }
        return null;
    }
}

