/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.maven.plugin;

import de.sormuras.junit.platform.maven.plugin.JUnitPlatformMojo;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

class MojoHelper {
    private final JUnitPlatformMojo mojo;
    private final PluginParameterExpressionEvaluator evaluator;

    MojoHelper(JUnitPlatformMojo mojo, MavenSession session, MojoExecution execution) {
        this.mojo = mojo;
        this.evaluator = new PluginParameterExpressionEvaluator(session, execution);
    }

    void autoConfigure(String markerName, Object dto) {
        Stream.of(dto.getClass().getDeclaredFields()).filter(it -> !Modifier.isStatic(it.getModifiers())).peek(it -> it.setAccessible(true)).forEach(field -> {
            String key = "${junit-platform." + markerName + '.' + field.getName() + "}";
            String value = this.evaluateProperty(key);
            if (value != null) {
                Class<?> type = field.getType();
                if (String.class == type) {
                    MojoHelper.set(field, dto, value);
                } else if (Boolean.TYPE == type) {
                    MojoHelper.set(field, dto, Boolean.parseBoolean(value));
                } else if (List.class == type) {
                    MojoHelper.set(field, dto, Arrays.asList(value.split(",")));
                } else if (Map.class == type) {
                    MojoHelper.set(field, dto, Stream.of(value.split(",")).map(it -> it.split("=")).collect(Collectors.toMap(it -> it[0], it -> it[1])));
                } else {
                    throw new IllegalArgumentException("Unsupported type: " + type);
                }
            }
        });
    }

    String evaluateProperty(String key) {
        try {
            return (String)this.evaluator.evaluate(key, String.class);
        }
        catch (ExpressionEvaluationException e) {
            this.mojo.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static void set(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

