/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.isolator;

import de.sormuras.junit.platform.isolator.Version;
import java.util.function.Function;

public enum GroupArtifact {
    ISOLATOR("de.sormuras.junit", "junit-platform-isolator", "ISOLATOR"),
    ISOLATOR_WORKER("de.sormuras.junit", "junit-platform-isolator-worker", "ISOLATOR"),
    JUNIT_JUPITER("org.junit.jupiter", "junit-jupiter", "JUNIT_JUPITER"),
    JUNIT_JUPITER_API("org.junit.jupiter", "junit-jupiter-api", "JUNIT_JUPITER"),
    JUNIT_JUPITER_ENGINE("org.junit.jupiter", "junit-jupiter-engine", "JUNIT_JUPITER"),
    JUNIT_PLATFORM_COMMONS("org.junit.platform", "junit-platform-commons", "JUNIT_PLATFORM"),
    JUNIT_PLATFORM_CONSOLE("org.junit.platform", "junit-platform-console", "JUNIT_PLATFORM"),
    JUNIT_PLATFORM_LAUNCHER("org.junit.platform", "junit-platform-launcher", "JUNIT_PLATFORM"),
    JUNIT_PLATFORM_REPORTING("org.junit.platform", "junit-platform-reporting", "JUNIT_PLATFORM"),
    JUNIT_VINTAGE_ENGINE("org.junit.vintage", "junit-vintage-engine", "JUNIT_VINTAGE");

    private final String group;
    private final String artifact;
    private final String string;
    private final String versionName;

    private GroupArtifact(String group, String artifact, String versionBaseName) {
        this.group = group;
        this.artifact = artifact;
        this.string = group + ':' + artifact;
        this.versionName = versionBaseName + "_VERSION";
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getGroup() {
        return this.group;
    }

    public Version getVersion() {
        return Version.valueOf(this.versionName);
    }

    public String toString() {
        return this.string;
    }

    public String toString(Function<Version, String> version) {
        return this.string + ':' + version.apply(this.getVersion());
    }

    public String toStringWithDefaultVersion() {
        return this.string + ':' + this.getVersion().getDefaultVersion();
    }
}

