/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.isolator;

import de.sormuras.junit.platform.isolator.TestMode;
import java.lang.module.FindException;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Modules {
    private final ModuleReference mainModuleReference;
    private final ModuleReference testModuleReference;
    private final TestMode mode;

    public Modules(Path mainPath, Path testPath) {
        this.mainModuleReference = Modules.getSingleModuleReferenceOrNull(mainPath);
        this.testModuleReference = Modules.getSingleModuleReferenceOrNull(testPath);
        this.mode = TestMode.of(Modules.getName(this.mainModuleReference), Modules.getName(this.testModuleReference));
    }

    public TestMode getMode() {
        return this.mode;
    }

    public Optional<String> getMainModuleName() {
        return Optional.ofNullable(Modules.getName(this.mainModuleReference));
    }

    public Optional<ModuleReference> getMainModuleReference() {
        return Optional.ofNullable(this.mainModuleReference);
    }

    public Optional<String> getTestModuleName() {
        return Optional.ofNullable(Modules.getName(this.testModuleReference));
    }

    public Optional<ModuleReference> getTestModuleReference() {
        return Optional.ofNullable(this.testModuleReference);
    }

    public String toString() {
        return String.format("Modules(11) [main=%s, test=%s]", this.toStringMainModule(), this.toStringTestModule());
    }

    public String toStringMainModule() {
        return Modules.toString(this.mainModuleReference);
    }

    public String toStringTestModule() {
        return Modules.toString(this.testModuleReference);
    }

    private static String getName(ModuleReference reference) {
        if (reference == null) {
            return null;
        }
        return reference.descriptor().name();
    }

    private static ModuleReference getSingleModuleReferenceOrNull(Path path) {
        Set<ModuleReference> all;
        try {
            all = ModuleFinder.of(path).findAll();
        }
        catch (FindException e) {
            return null;
        }
        Optional firstOpt = all.stream().findFirst();
        switch (all.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (ModuleReference)firstOpt.get();
            }
        }
        throw new IllegalArgumentException("expected exactly one module in " + path + " but found: " + all.stream().map(Object::toString).collect(Collectors.joining(", ", "<", ">")));
    }

    private static String toString(ModuleReference reference) {
        if (reference == null) {
            return "<empty>";
        }
        ModuleDescriptor module = reference.descriptor();
        StringBuilder builder = new StringBuilder();
        if (module.isOpen()) {
            builder.append("open ");
        }
        builder.append("module ").append(module.name());
        builder.append(" {");
        builder.append(" requires=").append(module.requires().stream().map(ModuleDescriptor.Requires::name).collect(Collectors.joining(", ", "[", "]")));
        builder.append(" packages=").append(module.packages());
        builder.append(" }");
        return builder.toString();
    }
}

