/*
 * Decompiled with CFR 0.152.
 */
package de.sormuras.junit.platform.isolator;

import de.sormuras.junit.platform.isolator.Driver;
import java.util.function.Consumer;

abstract class AbstractModuleInfoTestConsumer
implements Consumer<String> {
    final Driver driver;
    private String operation = null;

    AbstractModuleInfoTestConsumer(Driver driver) {
        this.driver = driver;
    }

    @Override
    public void accept(String line) {
        if (this.operation == null) {
            this.operation = line;
            this.driver.debug("Stored `{0}` for next round.", line);
            return;
        }
        String option = this.operation;
        this.operation = null;
        this.driver.debug("Handling `{0}` operator: `{1}`", option, line);
        String[] split = line.split("=");
        String sourceName = AbstractModuleInfoTestConsumer.extractModuleName(split[0]);
        String packageName = AbstractModuleInfoTestConsumer.extractPackageName(split[0]);
        String[] targetNames = split[1].split(",");
        this.accept(option, sourceName, packageName, targetNames);
    }

    abstract void accept(String var1, String var2, String var3, String[] var4);

    static String extractModuleName(String moduleNameWithOptionalPackageName) {
        int index = moduleNameWithOptionalPackageName.indexOf("/");
        if (index < 0) {
            return moduleNameWithOptionalPackageName;
        }
        return moduleNameWithOptionalPackageName.substring(0, index);
    }

    static String extractPackageName(String moduleNameWithOptionalPackageName) {
        int index = moduleNameWithOptionalPackageName.indexOf("/");
        if (index < 0) {
            return "";
        }
        return moduleNameWithOptionalPackageName.substring(index + 1);
    }
}

