/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.spring;

import com.qq.tars.client.Communicator;
import com.qq.tars.client.CommunicatorFactory;
import com.qq.tars.server.core.Server;
import com.qq.tars.spring.bean.CommunicatorBeanPostProcessor;
import com.qq.tars.spring.bean.ServletContainerCustomizer;
import com.qq.tars.spring.bean.TarsServerStartLifecycle;
import com.qq.tars.support.config.ConfigHelper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TarsServerConfiguration {
    private final Server server = Server.getInstance();

    @Bean
    public Server server() {
        return this.server;
    }

    @Bean
    public Communicator communicator() {
        return CommunicatorFactory.getInstance().getCommunicator();
    }

    @Bean
    public CommunicatorBeanPostProcessor communicatorBeanPostProcessor(Communicator communicator) {
        return new CommunicatorBeanPostProcessor(communicator);
    }

    @Bean
    public ConfigHelper configHelper() {
        return ConfigHelper.getInstance();
    }

    @Bean
    public ServletContainerCustomizer servletContainerCustomizer() {
        return new ServletContainerCustomizer();
    }

    @Bean
    public TarsServerStartLifecycle applicationStartLifecycle(Server server) {
        return new TarsServerStartLifecycle(server);
    }
}

