/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.server.apps;

import com.qq.tars.common.util.StringUtils;
import com.qq.tars.protocol.annotation.Servant;
import com.qq.tars.protocol.util.TarsHelper;
import com.qq.tars.server.apps.BaseAppContext;
import com.qq.tars.server.config.ConfigurationManager;
import com.qq.tars.server.config.ServantAdapterConfig;
import com.qq.tars.server.config.ServerConfig;
import com.qq.tars.server.core.AppContext;
import com.qq.tars.server.core.AppContextListener;
import com.qq.tars.server.core.AppService;
import com.qq.tars.server.core.ServantAdapter;
import com.qq.tars.server.core.ServantHomeSkeleton;
import com.qq.tars.spring.annotation.TarsListener;
import com.qq.tars.spring.annotation.TarsServant;
import java.util.Map;
import org.springframework.aop.framework.Advised;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;

public class SpringBootAppContext
extends BaseAppContext {
    private ApplicationContext applicationContext;

    public SpringBootAppContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected void loadServants() {
        this.loadAppContextListeners();
        this.loadAppServants();
    }

    private void loadAppContextListeners() {
        Map listenerMap = this.applicationContext.getBeansWithAnnotation(TarsListener.class);
        for (Map.Entry entry : listenerMap.entrySet()) {
            try {
                AppContextListener listener = (AppContextListener)entry.getValue();
                this.listeners.add(listener);
            }
            catch (ClassCastException e) {
                System.err.println("invalid listener config|It is NOT a ContextListener:" + entry.getValue().getClass());
            }
            catch (Exception e) {
                System.err.println("create listener instance failed.");
                e.printStackTrace();
            }
        }
    }

    private void loadAppServants() {
        Map servantMap = this.applicationContext.getBeansWithAnnotation(TarsServant.class);
        for (Map.Entry entry : servantMap.entrySet()) {
            try {
                ServantHomeSkeleton skeleton = this.loadServant(entry.getValue());
                this.skeletonMap.put(skeleton.name(), skeleton);
                this.appServantStarted((AppService)skeleton);
            }
            catch (Exception e) {
                System.err.println("init a Servant failed");
                e.printStackTrace();
            }
        }
    }

    private ServantHomeSkeleton loadServant(Object bean) throws Exception {
        String servantName;
        String homeName = null;
        Class<?> homeApiClazz = null;
        Class codecClazz = null;
        Class processorClazz = null;
        Object homeClassImpl = null;
        ServantHomeSkeleton skeleton = null;
        int maxLoadLimit = -1;
        ServerConfig serverCfg = ConfigurationManager.getInstance().getServerConfig();
        homeName = ((TarsServant)AnnotationUtils.getAnnotation(bean.getClass(), TarsServant.class)).name();
        if (StringUtils.isEmpty((String)homeName)) {
            throw new RuntimeException("servant name is null.");
        }
        homeName = String.format("%s.%s.%s", serverCfg.getApplication(), serverCfg.getServerName(), homeName);
        Class implClass = bean.getClass();
        if (bean instanceof Advised) {
            implClass = ((Advised)bean).getTargetSource().getTargetClass();
        }
        for (Class<?> clazz : implClass.getInterfaces()) {
            if (!clazz.isAnnotationPresent(Servant.class)) continue;
            homeApiClazz = clazz;
            break;
        }
        if (homeApiClazz == null) {
            throw new Exception("servant is not TarServant");
        }
        homeClassImpl = bean;
        if (TarsHelper.isServant(homeApiClazz) && !StringUtils.isEmpty((String)(servantName = homeApiClazz.getAnnotation(Servant.class).name())) && servantName.matches("^[\\w]+\\.[\\w]+\\.[\\w]+$")) {
            homeName = servantName;
        }
        ServantAdapterConfig servantAdapterConfig = (ServantAdapterConfig)serverCfg.getServantAdapterConfMap().get(homeName);
        ServantAdapter ServerAdapter = new ServantAdapter(servantAdapterConfig);
        skeleton = new ServantHomeSkeleton(homeName, homeClassImpl, homeApiClazz, codecClazz, processorClazz, maxLoadLimit);
        skeleton.setAppContext((AppContext)this);
        ServerAdapter.bind((AppService)skeleton);
        this.servantAdapterMap.put(homeName, ServerAdapter);
        return skeleton;
    }
}

