/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.composite;

import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.circuitbreaker.composite.MatchUtils;
import com.tencent.polaris.plugins.circuitbreaker.composite.PolarisCircuitBreaker;
import com.tencent.polaris.plugins.circuitbreaker.composite.ResourceCounters;
import com.tencent.polaris.plugins.circuitbreaker.composite.ResourceHealthChecker;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import com.tencent.polaris.specification.api.v1.fault.tolerance.FaultDetectorProto;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class CircuitBreakerRuleContainer {
    private static final Logger LOG = LoggerFactory.getLogger(CircuitBreakerRuleContainer.class);
    private final Resource resource;
    private final PolarisCircuitBreaker polarisCircuitBreaker;
    private final Function<String, Pattern> regexToPattern;

    public CircuitBreakerRuleContainer(Resource resource, PolarisCircuitBreaker polarisCircuitBreaker) {
        this.resource = resource;
        this.polarisCircuitBreaker = polarisCircuitBreaker;
        this.regexToPattern = regex -> {
            FlowCache flowCache = polarisCircuitBreaker.getExtensions().getFlowCache();
            return flowCache.loadOrStoreCompiledRegex(regex);
        };
        this.scheduleCircuitBreaker();
    }

    private FaultDetectorProto.FaultDetector selectFaultDetector(ServiceRule serviceRule) {
        if (null == serviceRule) {
            return null;
        }
        Object rule = serviceRule.getRule();
        if (null == rule) {
            return null;
        }
        return (FaultDetectorProto.FaultDetector)rule;
    }

    private static List<CircuitBreakerProto.CircuitBreakerRule> sortCircuitBreakerRules(List<CircuitBreakerProto.CircuitBreakerRule> rules) {
        ArrayList<CircuitBreakerProto.CircuitBreakerRule> outRules = new ArrayList<CircuitBreakerProto.CircuitBreakerRule>(rules);
        outRules.sort(new Comparator<CircuitBreakerProto.CircuitBreakerRule>(){

            @Override
            public int compare(CircuitBreakerProto.CircuitBreakerRule rule1, CircuitBreakerProto.CircuitBreakerRule rule2) {
                int methodResult;
                CircuitBreakerProto.RuleMatcher ruleMatcher1 = rule1.getRuleMatcher();
                String destNamespace1 = ruleMatcher1.getDestination().getNamespace();
                String destService1 = ruleMatcher1.getDestination().getService();
                String destMethod1 = ruleMatcher1.getDestination().getMethod().getValue().getValue();
                CircuitBreakerProto.RuleMatcher ruleMatcher2 = rule2.getRuleMatcher();
                String destNamespace2 = ruleMatcher2.getDestination().getNamespace();
                String destService2 = ruleMatcher2.getDestination().getService();
                String destMethod2 = ruleMatcher2.getDestination().getMethod().getValue().getValue();
                int svcResult = CircuitBreakerRuleContainer.compareService(destNamespace1, destService1, destNamespace2, destService2);
                if (svcResult != 0) {
                    return svcResult;
                }
                if (rule1.getLevel() == CircuitBreakerProto.Level.METHOD && rule1.getLevel() == rule2.getLevel() && (methodResult = CircuitBreakerRuleContainer.compareSingleValue(destMethod1, destMethod2)) != 0) {
                    return methodResult;
                }
                String srcNamespace1 = ruleMatcher1.getSource().getNamespace();
                String srcService1 = ruleMatcher1.getSource().getService();
                String srcNamespace2 = ruleMatcher2.getSource().getNamespace();
                String srcService2 = ruleMatcher2.getSource().getService();
                return CircuitBreakerRuleContainer.compareService(srcNamespace1, srcService1, srcNamespace2, srcService2);
            }
        });
        return outRules;
    }

    public static int compareSingleValue(String value1, String value2) {
        boolean serviceWildcard1 = MatchUtils.isWildcardMatcherSingle(value1);
        boolean serviceWildcard2 = MatchUtils.isWildcardMatcherSingle(value2);
        if (serviceWildcard1 && serviceWildcard2) {
            return 0;
        }
        if (serviceWildcard1) {
            return 1;
        }
        if (serviceWildcard2) {
            return -1;
        }
        return value1.compareTo(value2);
    }

    public static int compareService(String namespace1, String service1, String namespace2, String service2) {
        int nsResult = CircuitBreakerRuleContainer.compareSingleValue(namespace1, namespace2);
        if (nsResult != 0) {
            return nsResult;
        }
        return CircuitBreakerRuleContainer.compareSingleValue(service1, service2);
    }

    public static CircuitBreakerProto.CircuitBreakerRule selectRule(Resource resource, ServiceRule serviceRule, Function<String, Pattern> regexToPattern) {
        if (null == serviceRule) {
            return null;
        }
        Object rule = serviceRule.getRule();
        if (null == rule) {
            return null;
        }
        CircuitBreakerProto.CircuitBreaker circuitBreaker = (CircuitBreakerProto.CircuitBreaker)rule;
        List rules = circuitBreaker.getRulesList();
        if (rules.isEmpty()) {
            return null;
        }
        List<CircuitBreakerProto.CircuitBreakerRule> sortedRules = CircuitBreakerRuleContainer.sortCircuitBreakerRules(rules);
        for (CircuitBreakerProto.CircuitBreakerRule cbRule : sortedRules) {
            boolean methodMatched;
            if (!cbRule.getEnable()) continue;
            CircuitBreakerProto.Level level = resource.getLevel();
            if (cbRule.getLevel() != level) continue;
            CircuitBreakerProto.RuleMatcher ruleMatcher = cbRule.getRuleMatcher();
            CircuitBreakerProto.RuleMatcher.DestinationService destination = ruleMatcher.getDestination();
            if (!MatchUtils.matchService(resource.getService(), destination.getNamespace(), destination.getService())) continue;
            CircuitBreakerProto.RuleMatcher.SourceService source = ruleMatcher.getSource();
            if (!MatchUtils.matchService(resource.getCallerService(), source.getNamespace(), source.getService()) || !(methodMatched = MatchUtils.matchMethod(resource, destination.getMethod(), regexToPattern))) continue;
            return cbRule;
        }
        return null;
    }

    public void scheduleCircuitBreaker() {
        this.polarisCircuitBreaker.getPullRulesExecutors().schedule(new PullCircuitBreakerRuleTask(), 50L, TimeUnit.MILLISECONDS);
    }

    public void scheduleHealthCheck() {
        this.polarisCircuitBreaker.getPullRulesExecutors().schedule(new PullFaultDetectTask(), 100L, TimeUnit.MILLISECONDS);
    }

    public Resource getResource() {
        return this.resource;
    }

    private class PullFaultDetectTask
    implements Runnable {
        private PullFaultDetectTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Resource resource = CircuitBreakerRuleContainer.this.resource;
            synchronized (resource) {
                LOG.info("start to pull fault detect rule for resource {}", (Object)CircuitBreakerRuleContainer.this.resource);
                ResourceCounters resourceCounters = CircuitBreakerRuleContainer.this.polarisCircuitBreaker.getCountersCache().get(CircuitBreakerRuleContainer.this.resource.getLevel()).get(CircuitBreakerRuleContainer.this.resource);
                boolean faultDetectEnabled = false;
                CircuitBreakerProto.CircuitBreakerRule currentActiveRule = null;
                if (null != resourceCounters) {
                    currentActiveRule = resourceCounters.getCurrentActiveRule();
                }
                if (null != currentActiveRule && currentActiveRule.getEnable() && currentActiveRule.getFaultDetectConfig().getEnable()) {
                    ServiceRule faultDetectRule;
                    ServiceEventKey fdEventKey = new ServiceEventKey(CircuitBreakerRuleContainer.this.resource.getService(), ServiceEventKey.EventType.FAULT_DETECTING);
                    try {
                        faultDetectRule = CircuitBreakerRuleContainer.this.polarisCircuitBreaker.getServiceRuleProvider().getServiceRule(fdEventKey);
                    }
                    catch (Throwable t) {
                        LOG.warn("fail to get resource for {}", (Object)fdEventKey, (Object)t);
                        CircuitBreakerRuleContainer.this.polarisCircuitBreaker.getPullRulesExecutors().schedule(new PullFaultDetectTask(), 5L, TimeUnit.SECONDS);
                        return;
                    }
                    FaultDetectorProto.FaultDetector faultDetector = CircuitBreakerRuleContainer.this.selectFaultDetector(faultDetectRule);
                    Map<Resource, ResourceHealthChecker> healthCheckCache = CircuitBreakerRuleContainer.this.polarisCircuitBreaker.getHealthCheckCache();
                    Map<ServiceKey, Map<Resource, ResourceHealthChecker>> serviceHealthCheckCache = CircuitBreakerRuleContainer.this.polarisCircuitBreaker.getServiceHealthCheckCache();
                    if (null != faultDetector) {
                        ResourceHealthChecker curChecker = healthCheckCache.get(CircuitBreakerRuleContainer.this.resource);
                        if (null != curChecker) {
                            FaultDetectorProto.FaultDetector currentRule = curChecker.getFaultDetector();
                            if (StringUtils.equals((String)faultDetector.getRevision(), (String)currentRule.getRevision())) {
                                return;
                            }
                            curChecker.stop();
                        }
                        ResourceHealthChecker newHealthChecker = new ResourceHealthChecker(CircuitBreakerRuleContainer.this.resource, faultDetector, CircuitBreakerRuleContainer.this.polarisCircuitBreaker);
                        healthCheckCache.put(CircuitBreakerRuleContainer.this.resource, newHealthChecker);
                        if (CircuitBreakerRuleContainer.this.resource.getLevel() != CircuitBreakerProto.Level.INSTANCE) {
                            ServiceKey svcKey = CircuitBreakerRuleContainer.this.resource.getService();
                            Map<Resource, ResourceHealthChecker> resourceHealthCheckerMap = serviceHealthCheckCache.get(svcKey);
                            if (null == resourceHealthCheckerMap) {
                                resourceHealthCheckerMap = new ConcurrentHashMap<Resource, ResourceHealthChecker>();
                                serviceHealthCheckCache.put(svcKey, resourceHealthCheckerMap);
                            }
                            resourceHealthCheckerMap.put(CircuitBreakerRuleContainer.this.resource, newHealthChecker);
                        }
                        faultDetectEnabled = true;
                    }
                }
                if (!faultDetectEnabled) {
                    LOG.info("health check for resource {} is disabled, now stop the previous checker", (Object)CircuitBreakerRuleContainer.this.resource);
                    Map<Resource, ResourceHealthChecker> healthCheckCache = CircuitBreakerRuleContainer.this.polarisCircuitBreaker.getHealthCheckCache();
                    ResourceHealthChecker preChecker = healthCheckCache.remove(CircuitBreakerRuleContainer.this.resource);
                    if (null != preChecker) {
                        preChecker.stop();
                    }
                    if (CircuitBreakerRuleContainer.this.resource.getLevel() != CircuitBreakerProto.Level.INSTANCE) {
                        ServiceKey svcKey = CircuitBreakerRuleContainer.this.resource.getService();
                        Map<Resource, ResourceHealthChecker> resourceHealthCheckerMap = CircuitBreakerRuleContainer.this.polarisCircuitBreaker.getServiceHealthCheckCache().get(svcKey);
                        if (null != resourceHealthCheckerMap) {
                            resourceHealthCheckerMap.remove(CircuitBreakerRuleContainer.this.resource);
                            if (resourceHealthCheckerMap.isEmpty()) {
                                CircuitBreakerRuleContainer.this.polarisCircuitBreaker.getServiceHealthCheckCache().remove(svcKey);
                            }
                        }
                    }
                }
            }
        }
    }

    private class PullCircuitBreakerRuleTask
    implements Runnable {
        private PullCircuitBreakerRuleTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Resource resource = CircuitBreakerRuleContainer.this.resource;
            synchronized (resource) {
                ServiceRule circuitBreakRule;
                ServiceEventKey cbEventKey = new ServiceEventKey(CircuitBreakerRuleContainer.this.resource.getService(), ServiceEventKey.EventType.CIRCUIT_BREAKING);
                try {
                    circuitBreakRule = CircuitBreakerRuleContainer.this.polarisCircuitBreaker.getServiceRuleProvider().getServiceRule(cbEventKey);
                }
                catch (Throwable t) {
                    LOG.warn("fail to get resource for {}", (Object)cbEventKey, (Object)t);
                    CircuitBreakerRuleContainer.this.polarisCircuitBreaker.getPullRulesExecutors().schedule(new PullCircuitBreakerRuleTask(), 5L, TimeUnit.SECONDS);
                    return;
                }
                Map<Resource, ResourceCounters> resourceResourceCounters = CircuitBreakerRuleContainer.this.polarisCircuitBreaker.getCountersCache().get(CircuitBreakerRuleContainer.this.resource.getLevel());
                CircuitBreakerProto.CircuitBreakerRule circuitBreakerRule = CircuitBreakerRuleContainer.selectRule(CircuitBreakerRuleContainer.this.resource, circuitBreakRule, CircuitBreakerRuleContainer.this.regexToPattern);
                if (null != circuitBreakerRule) {
                    CircuitBreakerProto.CircuitBreakerRule currentActiveRule;
                    ResourceCounters resourceCounters = resourceResourceCounters.get(CircuitBreakerRuleContainer.this.resource);
                    if (null != resourceCounters && StringUtils.equals((String)(currentActiveRule = resourceCounters.getCurrentActiveRule()).getId(), (String)circuitBreakerRule.getId()) && StringUtils.equals((String)currentActiveRule.getRevision(), (String)circuitBreakerRule.getRevision())) {
                        return;
                    }
                    resourceResourceCounters.put(CircuitBreakerRuleContainer.this.resource, new ResourceCounters(CircuitBreakerRuleContainer.this.resource, circuitBreakerRule, CircuitBreakerRuleContainer.this.polarisCircuitBreaker.getStateChangeExecutors(), CircuitBreakerRuleContainer.this.polarisCircuitBreaker));
                    CircuitBreakerRuleContainer.this.scheduleHealthCheck();
                } else {
                    ResourceCounters oldCounters = resourceResourceCounters.remove(CircuitBreakerRuleContainer.this.resource);
                    if (null != oldCounters) {
                        LOG.info("start to destroyed counters {} for resource {}", (Object)oldCounters.getCurrentActiveRule().getName(), (Object)CircuitBreakerRuleContainer.this.resource);
                        oldCounters.setDestroyed(true);
                        CircuitBreakerRuleContainer.this.scheduleHealthCheck();
                    }
                }
            }
        }
    }
}

