/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.internal.CopyImpl;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyResult;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.CopyPartCallable;
import com.qcloud.cos.transfer.CopyPartRequestFactory;
import com.qcloud.cos.transfer.Transfer;
import com.qcloud.cos.transfer.TransferManager;
import com.qcloud.cos.transfer.TransferManagerConfiguration;
import com.qcloud.cos.transfer.TransferManagerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CopyCallable
implements Callable<CopyResult> {
    private final COS cos;
    private final ExecutorService threadPool;
    private final CopyObjectRequest copyObjectRequest;
    private String multipartUploadId;
    private final ObjectMetadata metadata;
    private final CopyImpl copy;
    private static final Log log = LogFactory.getLog(CopyCallable.class);
    private final TransferManagerConfiguration configuration;
    private final List<Future<PartETag>> futures = new ArrayList<Future<PartETag>>();
    private final ProgressListenerChain listenerChain;

    public CopyCallable(TransferManager transferManager, ExecutorService threadPool, CopyImpl copy, CopyObjectRequest copyObjectRequest, ObjectMetadata metadata, ProgressListenerChain progressListenerChain) {
        this.cos = transferManager.getCOSClient();
        this.configuration = transferManager.getConfiguration();
        this.threadPool = threadPool;
        this.copyObjectRequest = copyObjectRequest;
        this.metadata = metadata;
        this.listenerChain = progressListenerChain;
        this.copy = copy;
    }

    List<Future<PartETag>> getFutures() {
        return this.futures;
    }

    String getMultipartUploadId() {
        return this.multipartUploadId;
    }

    public boolean isMultipartCopy() {
        Region sourceRegion = this.copyObjectRequest.getSourceBucketRegion();
        Region destRegion = this.cos.getClientConfig().getRegion();
        String sourceStorageClass = (String)this.metadata.getRawMetadataValue("x-cos-storage-class");
        String destStorageClass = this.copyObjectRequest.getStorageClass();
        if (sourceStorageClass != null && destStorageClass != null && sourceStorageClass.equals(destStorageClass) && (sourceRegion == null || sourceRegion.equals(destRegion))) {
            return false;
        }
        return this.metadata.getContentLength() > this.configuration.getMultipartCopyThreshold();
    }

    @Override
    public CopyResult call() throws Exception {
        this.copy.setState(Transfer.TransferState.InProgress);
        if (this.isMultipartCopy()) {
            SDKProgressPublisher.publishProgress(this.listenerChain, ProgressEventType.TRANSFER_STARTED_EVENT);
            this.copyInParts();
            return null;
        }
        return this.copyInOneChunk();
    }

    private CopyResult copyInOneChunk() {
        CopyObjectResult copyObjectResult = this.cos.copyObject(this.copyObjectRequest);
        if (copyObjectResult == null) {
            return null;
        }
        CopyResult copyResult = new CopyResult();
        copyResult.setSourceBucketName(this.copyObjectRequest.getSourceBucketName());
        copyResult.setSourceKey(this.copyObjectRequest.getSourceKey());
        copyResult.setDestinationBucketName(this.copyObjectRequest.getDestinationBucketName());
        copyResult.setDestinationKey(this.copyObjectRequest.getDestinationKey());
        copyResult.setETag(copyObjectResult.getETag());
        copyResult.setVersionId(copyObjectResult.getVersionId());
        copyResult.setRequestId(copyObjectResult.getRequestId());
        copyResult.setDateStr(copyObjectResult.getDateStr());
        return copyResult;
    }

    private void copyInParts() throws Exception {
        this.multipartUploadId = this.initiateMultipartUpload(this.copyObjectRequest);
        long optimalPartSize = this.getOptimalPartSize(this.metadata.getContentLength());
        try {
            CopyPartRequestFactory requestFactory = new CopyPartRequestFactory(this.copyObjectRequest, this.multipartUploadId, optimalPartSize, this.metadata.getContentLength());
            this.copyPartsInParallel(requestFactory);
        }
        catch (Exception e) {
            SDKProgressPublisher.publishProgress(this.listenerChain, ProgressEventType.TRANSFER_FAILED_EVENT);
            this.abortMultipartCopy();
            throw new RuntimeException("Unable to perform multipart copy", e);
        }
    }

    private long getOptimalPartSize(long contentLengthOfSource) {
        long optimalPartSize = TransferManagerUtils.calculateOptimalPartSizeForCopy(this.copyObjectRequest, this.configuration, contentLengthOfSource);
        log.debug((Object)("Calculated optimal part size: " + optimalPartSize));
        return optimalPartSize;
    }

    private void copyPartsInParallel(CopyPartRequestFactory requestFactory) {
        while (requestFactory.hasMoreRequests()) {
            if (this.threadPool.isShutdown()) {
                throw new CancellationException("TransferManager has been shutdown");
            }
            CopyPartRequest request = requestFactory.getNextCopyPartRequest();
            this.futures.add(this.threadPool.submit(new CopyPartCallable(this.cos, request)));
        }
    }

    private String initiateMultipartUpload(CopyObjectRequest origReq) {
        InitiateMultipartUploadRequest req = (InitiateMultipartUploadRequest)new InitiateMultipartUploadRequest(origReq.getDestinationBucketName(), origReq.getDestinationKey()).withCannedACL(origReq.getCannedAccessControlList()).withAccessControlList(origReq.getAccessControlList()).withStorageClass(origReq.getStorageClass()).withGeneralProgressListener(origReq.getGeneralProgressListener());
        ObjectMetadata newObjectMetadata = origReq.getNewObjectMetadata();
        if (newObjectMetadata == null) {
            newObjectMetadata = new ObjectMetadata();
        }
        if (newObjectMetadata.getContentType() == null) {
            newObjectMetadata.setContentType(this.metadata.getContentType());
        }
        req.setObjectMetadata(newObjectMetadata);
        String uploadId = this.cos.initiateMultipartUpload(req).getUploadId();
        log.debug((Object)("Initiated new multipart upload: " + uploadId));
        return uploadId;
    }

    private void abortMultipartCopy() {
        try {
            AbortMultipartUploadRequest abortRequest = new AbortMultipartUploadRequest(this.copyObjectRequest.getDestinationBucketName(), this.copyObjectRequest.getDestinationKey(), this.multipartUploadId);
            this.cos.abortMultipartUpload(abortRequest);
        }
        catch (Exception e) {
            log.info((Object)("Unable to abort multipart upload, you may need to manually remove uploaded parts: " + e.getMessage()), (Throwable)e);
        }
    }
}

