/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.internal.CosClientAbortTask;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosClientAbortTaskImpl
implements CosClientAbortTask {
    private volatile boolean hasTaskExecuted;
    private HttpRequestBase currentHttpRequest;
    private final Thread thread;
    private volatile boolean isCancelled;
    private static final Logger log = LoggerFactory.getLogger(CosClientAbortTaskImpl.class);
    private final Object lock = new Object();

    public CosClientAbortTaskImpl(Thread thread) {
        this.thread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isCancelled) {
                return;
            }
            this.hasTaskExecuted = true;
            if (!this.thread.isInterrupted()) {
                log.debug("request timeout and current thread will be interrupted");
                this.thread.interrupt();
            }
            if (!this.currentHttpRequest.isAborted()) {
                log.debug("request timeout and current http request will be aborted");
                this.currentHttpRequest.abort();
            }
        }
    }

    @Override
    public void setCurrentHttpRequest(HttpRequestBase newRequest) {
        this.currentHttpRequest = newRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasClientExecutionAborted() {
        Object object = this.lock;
        synchronized (object) {
            return this.hasTaskExecuted;
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.isCancelled = true;
        }
    }
}

