/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.transfer;

import com.qcloud.cos.COS;
import com.qcloud.cos.event.ProgressEventType;
import com.qcloud.cos.event.ProgressListenerChain;
import com.qcloud.cos.event.SDKProgressPublisher;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyResult;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.transfer.CopyMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;

public class CompleteMultipartCopy
implements Callable<CopyResult> {
    private final String uploadId;
    private final COS cos;
    private final CopyObjectRequest origReq;
    private final List<Future<PartETag>> futures;
    private final CopyMonitor monitor;
    private final ProgressListenerChain listener;

    public CompleteMultipartCopy(String uploadId, COS cos, CopyObjectRequest copyObjectRequest, List<Future<PartETag>> futures, ProgressListenerChain progressListenerChain, CopyMonitor monitor) {
        this.uploadId = uploadId;
        this.cos = cos;
        this.origReq = copyObjectRequest;
        this.futures = futures;
        this.listener = progressListenerChain;
        this.monitor = monitor;
    }

    @Override
    public CopyResult call() throws Exception {
        CompleteMultipartUploadResult res;
        try {
            CompleteMultipartUploadRequest req = (CompleteMultipartUploadRequest)new CompleteMultipartUploadRequest(this.origReq.getDestinationBucketName(), this.origReq.getDestinationKey(), this.uploadId, this.collectPartETags()).withGeneralProgressListener(this.origReq.getGeneralProgressListener());
            res = this.cos.completeMultipartUpload(req);
        }
        catch (Exception e) {
            SDKProgressPublisher.publishProgress(this.listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw e;
        }
        CopyResult copyResult = new CopyResult();
        copyResult.setSourceBucketName(this.origReq.getSourceBucketName());
        copyResult.setSourceKey(this.origReq.getSourceKey());
        copyResult.setDestinationBucketName(res.getBucketName());
        copyResult.setDestinationKey(res.getKey());
        copyResult.setETag(res.getETag());
        copyResult.setVersionId(res.getVersionId());
        copyResult.setRequestId(res.getRequestId());
        copyResult.setDateStr(res.getDateStr());
        copyResult.setCrc64Ecma(res.getCrc64Ecma());
        this.monitor.copyComplete();
        return copyResult;
    }

    private List<PartETag> collectPartETags() {
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        for (Future<PartETag> future : this.futures) {
            try {
                partETags.add(future.get());
            }
            catch (Exception e) {
                throw new CosClientException("Unable to copy part: " + e.getCause().getMessage(), e.getCause());
            }
        }
        return partETags;
    }
}

