/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.cihandler;

import com.qcloud.cos.internal.ParserMediaInfoUtils;
import com.qcloud.cos.internal.cihandler.CIAbstractHandler;
import com.qcloud.cos.model.ciModel.common.MediaOutputObject;
import com.qcloud.cos.model.ciModel.job.MediaAudioObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatFragmentObject;
import com.qcloud.cos.model.ciModel.job.MediaConcatTemplateObject;
import com.qcloud.cos.model.ciModel.job.MediaContainerObject;
import com.qcloud.cos.model.ciModel.job.MediaDigitalWatermark;
import com.qcloud.cos.model.ciModel.job.MediaJobObject;
import com.qcloud.cos.model.ciModel.job.MediaJobResponse;
import com.qcloud.cos.model.ciModel.job.MediaRemoveWaterMark;
import com.qcloud.cos.model.ciModel.job.MediaTimeIntervalObject;
import com.qcloud.cos.model.ciModel.job.MediaTransConfigObject;
import com.qcloud.cos.model.ciModel.job.MediaTranscodeVideoObject;
import com.qcloud.cos.model.ciModel.job.MediaVideoObject;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaFormat;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoAudio;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoSubtitle;
import com.qcloud.cos.model.ciModel.mediaInfo.MediaInfoVideo;
import java.util.List;
import org.xml.sax.Attributes;

public class DescribeMediaJobHandler
extends CIAbstractHandler {
    MediaJobResponse response = new MediaJobResponse();
    List<MediaConcatFragmentObject> concatFragmentList = this.response.getJobsDetail().getOperation().getMediaConcatTemplate().getConcatFragmentList();

    @Override
    protected void doStartElement(String uri, String name, String qName, Attributes attrs) {
        if ("ConcatFragment".equals(name)) {
            this.concatFragmentList.add(new MediaConcatFragmentObject());
        }
    }

    @Override
    protected void doEndElement(String uri, String name, String qName) {
        this.process(this.response, name);
    }

    public MediaJobResponse getResponse() {
        return this.response;
    }

    public void process(MediaJobResponse response, String name) {
        MediaDigitalWatermark digitalWatermark;
        Object video;
        Object audio;
        MediaJobObject jobsDetail = response.getJobsDetail();
        if (this.in("Response", "JobsDetail")) {
            ParserMediaInfoUtils.parseMediaJobsDetail(jobsDetail, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Input")) {
            jobsDetail.getInput().setObject(this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation")) {
            if ("TemplateId".equalsIgnoreCase(name)) {
                jobsDetail.getOperation().setTemplateId(this.getText());
            } else if ("WatermarkTemplateId".equalsIgnoreCase(name)) {
                jobsDetail.getOperation().getWatermarkTemplateId().add(this.getText());
            }
        } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Format")) {
            MediaFormat format = jobsDetail.getOperation().getMediaInfo().getFormat();
            ParserMediaInfoUtils.ParsingMediaFormat(format, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Audio")) {
            audio = jobsDetail.getOperation().getMediaInfo().getStream().getAudio();
            ParserMediaInfoUtils.ParsingStreamAudio((MediaInfoAudio)audio, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Subtitle")) {
            MediaInfoSubtitle subtitle = jobsDetail.getOperation().getMediaInfo().getStream().getSubtitle();
            ParserMediaInfoUtils.ParsingSubtitle(subtitle, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation", "MediaInfo", "Stream", "Video")) {
            video = jobsDetail.getOperation().getMediaInfo().getStream().getVideo();
            ParserMediaInfoUtils.ParsingMediaVideo((MediaInfoVideo)video, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation", "RemoveWatermark")) {
            MediaRemoveWaterMark removeWatermark = jobsDetail.getOperation().getRemoveWatermark();
            ParserMediaInfoUtils.ParsingRemoveWatermark(removeWatermark, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Container")) {
            if ("Format".equalsIgnoreCase(name)) {
                jobsDetail.getOperation().getTranscode().getContainer().setFormat(this.getText());
            }
        } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Video")) {
            audio = jobsDetail.getOperation().getTranscode().getAudio();
            ParserMediaInfoUtils.ParsingStreamAudio((MediaAudioObject)audio, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "Audio")) {
            video = jobsDetail.getOperation().getTranscode().getVideo();
            ParserMediaInfoUtils.ParsingMediaVideo((MediaTranscodeVideoObject)video, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "TransConfig")) {
            MediaTransConfigObject transConfig = jobsDetail.getOperation().getTranscode().getTransConfig();
            ParserMediaInfoUtils.ParsingTransConfig(transConfig, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation", "Transcode", "TimeInterval")) {
            MediaTimeIntervalObject timeInterval = jobsDetail.getOperation().getTranscode().getTimeInterval();
            ParserMediaInfoUtils.ParsingMediaTimeInterval(timeInterval, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation", "DigitalWatermark")) {
            digitalWatermark = response.getJobsDetail().getOperation().getDigitalWatermark();
            ParserMediaInfoUtils.ParsingDigitalWatermark(digitalWatermark, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation", "ExtractDigitalWatermark")) {
            digitalWatermark = response.getJobsDetail().getOperation().getExtractDigitalWatermark();
            ParserMediaInfoUtils.ParsingDigitalWatermark(digitalWatermark, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation", "Output")) {
            MediaOutputObject output = jobsDetail.getOperation().getOutput();
            switch (name) {
                case "Bucket": {
                    output.setBucket(this.getText());
                    break;
                }
                case "Object": {
                    output.setObject(this.getText());
                    break;
                }
                case "Region": {
                    output.setRegion(this.getText());
                }
            }
        }
        MediaConcatTemplateObject mediaConcatTemplate = response.getJobsDetail().getOperation().getMediaConcatTemplate();
        if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "ConcatFragment")) {
            MediaConcatFragmentObject mediaConcatFragmentObject = this.concatFragmentList.get(this.concatFragmentList.size() - 1);
            switch (name) {
                case "Mode": {
                    mediaConcatFragmentObject.setMode(this.getText());
                    break;
                }
                case "Url": {
                    mediaConcatFragmentObject.setUrl(this.getText());
                    break;
                }
                case "StartTime": {
                    mediaConcatFragmentObject.setStartTime(this.getText());
                    break;
                }
                case "EndTime": {
                    mediaConcatFragmentObject.setEndTime(this.getText());
                    break;
                }
            }
        } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Audio")) {
            MediaAudioObject audio2 = mediaConcatTemplate.getAudio();
            ParserMediaInfoUtils.ParsingMediaAudio(audio2, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Video")) {
            MediaVideoObject video2 = mediaConcatTemplate.getVideo();
            ParserMediaInfoUtils.ParsingMediaVideo(video2, name, this.getText());
        } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate", "Container")) {
            MediaContainerObject container = mediaConcatTemplate.getContainer();
            if ("Format".equals(name)) {
                container.setFormat(this.getText());
            }
        } else if (this.in("Response", "JobsDetail", "Operation", "ConcatTemplate") && "Index".equals(name)) {
            mediaConcatTemplate.setIndex(this.getText());
        }
    }
}

