/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

public enum BucketNameUtils {

    private static final int MIN_BUCKET_NAME_LENGTH = 1;
    private static final int MAX_BUCKET_NAME_LENGTH = 40;

    public static void validateBucketName(String bucketName) throws IllegalArgumentException {
        if (bucketName == null) {
            throw new IllegalArgumentException("Bucket Name cannot be null");
        }
        if (bucketName.length() < 1 || bucketName.length() > 40) {
            throw new IllegalArgumentException("bucketName length must between 1 and 40 characters long");
        }
        for (int i = 0; i < bucketName.length(); ++i) {
            char next = bucketName.charAt(i);
            if (next == '-' || next >= 'a' && next <= 'z' || next >= '0' && next <= '9') continue;
            if (next >= 'A' && next <= 'Z') {
                throw new IllegalArgumentException("Bucket name should not contain uppercase characters");
            }
            if (next == ' ' || next == '\t' || next == '\r' || next == '\n') {
                throw new IllegalArgumentException("Bucket name should not contain white space");
            }
            throw new IllegalArgumentException("Bucket name only should contain lowercase characters, num and -");
        }
    }
}

