/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.assumerole;

import com.tencent.cloud.Policy;
import com.tencent.cloud.Statement;
import com.tencent.cloud.cos.util.Jackson;
import java.util.Properties;

public class AssumeRoleParam {
    private String secretId = "";
    private String secretKey = "";
    private int durationSec = 0;
    private String region = "";
    private String host = "";
    private String roleArn = "";
    private String roleSessionName = "";
    private String signatureMethod = "";
    private String[] resources = new String[0];
    private String[] actions = new String[0];
    private String policy = "";

    public void Parse(Properties properties) {
        if (properties == null) {
            throw new NullPointerException("null properties");
        }
        this.secretId = properties.getProperty("SecretId", "");
        this.secretKey = properties.getProperty("SecretKey", "");
        this.region = properties.getProperty("region", "");
        this.signatureMethod = properties.getProperty("SignatureMethod", "HmacSHA1");
        String tmpDurationSec = properties.getProperty("durationSeconds", "");
        this.durationSec = tmpDurationSec.isEmpty() ? 0 : Integer.parseInt(tmpDurationSec);
        this.roleArn = properties.getProperty("RoleArn", "");
        this.roleSessionName = properties.getProperty("RoleSessionName", "");
        this.host = properties.getProperty("host", "sts.internal.tencentcloudapi.com");
        String tmpPolicy = properties.getProperty("policy", "");
        if (tmpPolicy.isEmpty()) {
            String tmpActions = properties.getProperty("policy.actions", "");
            String tmpResources = properties.getProperty("policy.resources", "");
            if (!tmpActions.isEmpty() || !tmpResources.isEmpty()) {
                this.actions = tmpActions.split(",");
                this.resources = tmpResources.split(",");
                this.policy = this.buildPolicy();
            }
        } else {
            this.policy = tmpPolicy;
        }
    }

    public void check() {
        if (this.secretId.isEmpty()) {
            throw new IllegalArgumentException("empty secretId");
        }
        if (this.secretKey.isEmpty()) {
            throw new IllegalArgumentException("empty secretId");
        }
        if (this.region.isEmpty()) {
            throw new IllegalArgumentException("empty region");
        }
        if (this.host.isEmpty()) {
            throw new IllegalArgumentException("empty host");
        }
        if (this.signatureMethod.isEmpty()) {
            throw new IllegalArgumentException("empty signatureMethod");
        }
        if (this.roleArn.isEmpty()) {
            throw new IllegalArgumentException("empty roleArn");
        }
        if (this.roleSessionName.isEmpty()) {
            throw new IllegalArgumentException("empty roleSessionName");
        }
    }

    private String buildPolicy() {
        Statement statement = new Statement();
        statement.setEffect("allow");
        for (String action : this.actions) {
            statement.addAction(action);
        }
        for (String res : this.resources) {
            statement.addResource(res);
        }
        Policy tmpPolicy = new Policy();
        tmpPolicy.setVersion("2.0");
        tmpPolicy.addStatement(statement);
        return Jackson.toJsonPrettyString(tmpPolicy);
    }

    public String getSecretId() {
        return this.secretId;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public int getDurationSec() {
        return this.durationSec;
    }

    public void setDurationSec(int durationSec) {
        this.durationSec = durationSec;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleSessionName() {
        return this.roleSessionName;
    }

    public void setRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public String[] getResources() {
        return this.resources;
    }

    public void setResources(String[] resources) {
        this.resources = resources;
    }

    public String[] getActions() {
        return this.actions;
    }

    public void setActions(String[] actions) {
        this.actions = actions;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }
}

