/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.jdk.Jvm;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.windows.WindowsJavaIOSubstitutions;
import com.oracle.svm.core.windows.WindowsJavaNIOSubstitutions;
import com.oracle.svm.core.windows.WindowsJavaNetSubstitutions;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class WindowsNativeLibrarySupport
implements PlatformNativeLibrarySupport {
    WindowsNativeLibrarySupport() {
    }

    static void initialize() {
        ImageSingletons.add(PlatformNativeLibrarySupport.class, (Object)new WindowsNativeLibrarySupport());
    }

    @Override
    public boolean initializeBuiltinLibraries() {
        if (!WindowsJavaNetSubstitutions.initIDs()) {
            return false;
        }
        if (!WindowsJavaIOSubstitutions.initIDs()) {
            return false;
        }
        return WindowsJavaNIOSubstitutions.initIDs();
    }

    @Override
    public WindowsNativeLibrary createLibrary(String canonical, boolean builtIn) {
        return new WindowsNativeLibrary(canonical, builtIn);
    }

    @Override
    public PointerBase findBuiltinSymbol(String name) {
        try (CTypeConversion.CCharPointerHolder symbol = CTypeConversion.toCString((CharSequence)name);){
            Pointer builtinHandle = WinBase.GetModuleHandleA(WordFactory.nullPointer());
            PointerBase pointerBase = WinBase.GetProcAddress(builtinHandle, (PointerBase)symbol.get());
            return pointerBase;
        }
    }

    class WindowsNativeLibrary
    implements PlatformNativeLibrarySupport.NativeLibrary {
        private final String canonicalIdentifier;
        private final boolean builtin;
        private Pointer dlhandle = (Pointer)WordFactory.nullPointer();

        WindowsNativeLibrary(String canonicalIdentifier, boolean builtin) {
            Jvm.initialize();
            this.canonicalIdentifier = canonicalIdentifier;
            this.builtin = builtin;
        }

        @Override
        public String getCanonicalIdentifier() {
            return this.canonicalIdentifier;
        }

        @Override
        public boolean isBuiltin() {
            return this.builtin;
        }

        @Override
        public boolean load() {
            if (this.builtin) {
                return true;
            }
            assert (this.dlhandle.isNull());
            try (CTypeConversion.CCharPointerHolder dllPathPin = CTypeConversion.toCString((CharSequence)this.canonicalIdentifier);){
                CCharPointer dllPathPtr = dllPathPin.get();
                this.dlhandle = WinBase.LoadLibraryA((PointerBase)dllPathPtr);
            }
            return this.dlhandle.isNonNull();
        }

        @Override
        public PointerBase findSymbol(String name) {
            if (this.builtin) {
                PointerBase addr = WindowsNativeLibrarySupport.this.findBuiltinSymbol(name);
                return addr;
            }
            assert (this.dlhandle.isNonNull());
            try (CTypeConversion.CCharPointerHolder symbol = CTypeConversion.toCString((CharSequence)name);){
                PointerBase addr;
                PointerBase pointerBase = addr = WinBase.GetProcAddress(this.dlhandle, (PointerBase)symbol.get());
                return pointerBase;
            }
        }
    }
}

