/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.ParkEvent;
import com.oracle.svm.core.thread.VMOperationControl;
import com.oracle.svm.core.util.TimeUtils;

final class UnsafeParkSupport {
    private UnsafeParkSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParkEvent.WaitResult park() {
        VMOperationControl.guaranteeOkayToBlock("[UnsafeParkSupport.park(): Should not park when it is not okay to block.]");
        Thread thread = Thread.currentThread();
        ParkEvent parkEvent = UnsafeParkSupport.ensureParkEvent(thread);
        int oldStatus = JavaThreads.getThreadStatus(thread);
        JavaThreads.setThreadStatus(thread, 657);
        try {
            ParkEvent.WaitResult waitResult = parkEvent.condWait();
            return waitResult;
        }
        finally {
            JavaThreads.setThreadStatus(thread, oldStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ParkEvent.WaitResult park(long delayNanos) {
        VMOperationControl.guaranteeOkayToBlock("[UnsafeParkSupport.park(long): Should not park when it is not okay to block.]");
        Thread thread = Thread.currentThread();
        ParkEvent parkEvent = UnsafeParkSupport.ensureParkEvent(thread);
        long startNanos = System.nanoTime();
        long endNanos = TimeUtils.addOrMaxValue(startNanos, delayNanos);
        int oldStatus = JavaThreads.getThreadStatus(thread);
        JavaThreads.setThreadStatus(thread, 673);
        try {
            long remainingNanos = delayNanos;
            while (0L < remainingNanos) {
                ParkEvent.WaitResult result = parkEvent.condTimedWait(remainingNanos);
                if (result == ParkEvent.WaitResult.INTERRUPTED || result == ParkEvent.WaitResult.UNPARKED) {
                    ParkEvent.WaitResult waitResult = result;
                    return waitResult;
                }
                remainingNanos = endNanos - System.nanoTime();
            }
            ParkEvent.WaitResult waitResult = ParkEvent.WaitResult.TIMED_OUT;
            return waitResult;
        }
        finally {
            JavaThreads.setThreadStatus(thread, oldStatus);
        }
    }

    static void unpark(Thread thread) {
        UnsafeParkSupport.ensureParkEvent(thread).unpark();
    }

    private static ParkEvent ensureParkEvent(Thread thread) {
        return ParkEvent.initializeOnce(JavaThreads.getUnsafeParkEvent(thread), false);
    }
}

