/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.StackTraceBuilder;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackWalker;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

@TargetClass(value=Throwable.class)
final class Target_java_lang_Throwable {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private Object backtrace;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    StackTraceElement[] stackTrace;
    @Alias
    String detailMessage;

    Target_java_lang_Throwable() {
    }

    @Substitute
    private void addSuppressed(Throwable exception) {
    }

    @Substitute
    @NeverInline(value="Prevent inlining in Truffle compilations")
    private Object fillInStackTrace() {
        Pointer sp = KnownIntrinsics.readCallerStackPointer();
        CodePointer ip = KnownIntrinsics.readReturnAddress();
        StackTraceBuilder stackTraceBuilder = new StackTraceBuilder(true);
        JavaStackWalker.walkCurrentThread(sp, ip, stackTraceBuilder);
        this.stackTrace = stackTraceBuilder.getTrace();
        return this;
    }

    @Substitute
    private StackTraceElement[] getOurStackTrace() {
        if (this.stackTrace != null) {
            return this.stackTrace;
        }
        return new StackTraceElement[0];
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    int getStackTraceDepth() {
        if (this.stackTrace != null) {
            return this.stackTrace.length;
        }
        return 0;
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    StackTraceElement getStackTraceElement(int index) {
        if (this.stackTrace == null) {
            throw new IndexOutOfBoundsException();
        }
        return this.stackTrace[index];
    }
}

