/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.jdk.IgnoreForGetCallerClass;
import com.oracle.svm.core.stack.StackFrameVisitor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

class GetCallerClassVisitor
implements StackFrameVisitor {
    int depth;
    Class<?> result;

    GetCallerClassVisitor() {
    }

    @Override
    public boolean visitFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame) {
        if (deoptimizedFrame != null) {
            for (DeoptimizedFrame.VirtualFrame frame = deoptimizedFrame.getTopFrame(); frame != null; frame = frame.getCaller()) {
                if (this.visitJavaFrame(frame.getFrameInfo())) continue;
                return false;
            }
        } else {
            CodeInfoQueryResult codeInfo = CodeInfoTable.lookupCodeInfoQueryResult(ip);
            for (FrameInfoQueryResult frameInfo = codeInfo.getFrameInfo(); frameInfo != null; frameInfo = frameInfo.getCaller()) {
                if (this.visitJavaFrame(frameInfo)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean visitJavaFrame(FrameInfoQueryResult frameInfo) {
        ++this.depth;
        if (this.depth == 1) {
            return true;
        }
        if (frameInfo.getSourceClass() != null && frameInfo.getSourceClass().getAnnotation(IgnoreForGetCallerClass.class) != null) {
            return true;
        }
        if (frameInfo.getSourceClass() == Method.class && "invoke".equals(frameInfo.getSourceMethodName()) || frameInfo.getSourceClass() == Constructor.class && "newInstance".equals(frameInfo.getSourceMethodName()) || frameInfo.getSourceClass() == Class.class && "newInstance".equals(frameInfo.getSourceMethodName())) {
            return true;
        }
        this.result = frameInfo.getSourceClass();
        return false;
    }
}

