/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.PinnedAllocator;
import java.lang.management.MemoryMXBean;
import java.util.List;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public abstract class Heap {
    @Fold
    public static Heap getHeap() {
        return (Heap)ImageSingletons.lookup(Heap.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    protected Heap() {
    }

    public abstract void suspendAllocation();

    public abstract void resumeAllocation();

    public abstract void disableAllocation(IsolateThread var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public abstract boolean isAllocationDisallowed();

    public abstract PinnedAllocator createPinnedAllocator();

    public abstract GC getGC();

    public abstract void walkObjects(ObjectVisitor var1);

    public abstract List<Class<?>> getClassList();

    public abstract ObjectHeader getObjectHeader();

    public abstract MemoryMXBean getMemoryMXBean();

    public abstract void tearDown();
}

