/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.network;

import com.oracle.bedrock.io.NetworkHelper;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AvailablePortIterator
implements Iterator<Integer>,
Iterable<Integer> {
    private static final int MINIMUM_PORT = 1;
    public static final int MAXIMUM_PORT = 65535;
    private static final int LOW_PORT_THRESHOLD = 5;
    private static final int IDEAL_AVAILABLE_PORTS = 10;
    private Set<InetAddress> inetAddresses = new LinkedHashSet<InetAddress>();
    private int portRangeStart;
    private int portRangeEnd;
    private Queue<Map<InetAddress, ServerSocket>> serverSockets;
    private Queue<Map<InetAddress, DatagramSocket>> datagramSockets;
    private int lastCheckedPort;

    public AvailablePortIterator() {
        this(1, 65535, NetworkHelper.getWildcardAddress());
    }

    public AvailablePortIterator(int portRangeStart) {
        this(portRangeStart, 65535, NetworkHelper.getWildcardAddress());
    }

    public AvailablePortIterator(int portRangeStart, int portRangeEnd) {
        this(portRangeStart, portRangeEnd, NetworkHelper.getWildcardAddress());
    }

    public AvailablePortIterator(int portRangeStart, int portRangeEnd, InetAddress ... inetAddresses) {
        this(portRangeStart, portRangeEnd, Arrays.asList(inetAddresses));
    }

    public AvailablePortIterator(int portRangeStart, int portRangeEnd, Iterable<InetAddress> inetAddresses) {
        if (inetAddresses != null) {
            for (InetAddress inetAddress : inetAddresses) {
                this.inetAddresses.add(inetAddress);
            }
        }
        this.portRangeStart = portRangeStart;
        this.portRangeEnd = portRangeEnd;
        this.serverSockets = new ConcurrentLinkedQueue<Map<InetAddress, ServerSocket>>();
        this.datagramSockets = new ConcurrentLinkedQueue<Map<InetAddress, DatagramSocket>>();
        this.lastCheckedPort = portRangeStart - 1;
        this.acquireAvailablePorts(5, 10);
    }

    public AvailablePortIterator(String host, int portRangeStart, int portRangeEnd) throws UnknownHostException {
        this(portRangeStart, portRangeEnd, InetAddress.getByName(host));
    }

    private boolean isPortAvailable(int port) {
        if (port < this.portRangeStart || port > this.portRangeEnd) {
            return false;
        }
        HashMap<InetAddress, ServerSocket> serverSocketMap = new HashMap<InetAddress, ServerSocket>();
        HashMap<InetAddress, DatagramSocket> datagramSocketMap = new HashMap<InetAddress, DatagramSocket>();
        for (InetAddress inetAddress : this.inetAddresses) {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket();
                serverSocket.bind(new InetSocketAddress(inetAddress, port));
            }
            catch (IOException ioException) {
                if (serverSocket == null) break;
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
                break;
            }
            DatagramSocket datagramSocket = null;
            try {
                datagramSocket = new DatagramSocket(port, inetAddress);
                datagramSocketMap.put(inetAddress, datagramSocket);
                serverSocketMap.put(inetAddress, serverSocket);
            }
            catch (IOException ioException) {
                try {
                    serverSocket.close();
                    if (datagramSocket == null) break;
                    datagramSocket.close();
                }
                catch (IOException iOException) {}
                break;
            }
        }
        if (serverSocketMap.size() == this.inetAddresses.size()) {
            this.serverSockets.add(serverSocketMap);
            this.datagramSockets.add(datagramSocketMap);
            return true;
        }
        for (ServerSocket serverSocket : serverSocketMap.values()) {
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {}
        }
        for (DatagramSocket datagramSocket : datagramSocketMap.values()) {
            try {
                datagramSocket.close();
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public Iterable<InetAddress> getInetAddresses() {
        return this.inetAddresses;
    }

    private synchronized int acquireAvailablePorts(int minimumThreshold, int idealQueueSize) {
        int count;
        int n = count = this.serverSockets.size() < minimumThreshold ? this.serverSockets.size() + idealQueueSize : this.serverSockets.size();
        while (this.serverSockets.size() < count && this.lastCheckedPort < this.portRangeEnd) {
            this.isPortAvailable(++this.lastCheckedPort);
        }
        return this.serverSockets.size();
    }

    @Override
    public Iterator<Integer> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.acquireAvailablePorts(5, 10) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer next() {
        if (this.hasNext()) {
            int port;
            boolean reacquire;
            do {
                Map<InetAddress, DatagramSocket> datagramSocketMap;
                Map<InetAddress, ServerSocket> serverSocketMap;
                Iterator<Integer> iterator = this;
                synchronized (iterator) {
                    if (this.acquireAvailablePorts(5, 10) == 0) {
                        throw new UnsupportedOperationException("Exhausted all available ports");
                    }
                    serverSocketMap = this.serverSockets.remove();
                    datagramSocketMap = this.datagramSockets.remove();
                }
                port = serverSocketMap.values().iterator().next().getLocalPort();
                reacquire = false;
                for (ServerSocket serverSocket : serverSocketMap.values()) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e) {
                        reacquire = true;
                    }
                }
                for (DatagramSocket datagramSocket : datagramSocketMap.values()) {
                    try {
                        datagramSocket.close();
                    }
                    catch (Exception e) {
                        reacquire = true;
                    }
                }
            } while (reacquire);
            return port;
        }
        throw new NoSuchElementException("Attempted to iterate outside of the range of available ports");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("It's illegal to attempt to remove() a port from an AvailablePortIterator");
    }

    public String toString() {
        ArrayList<Map<InetAddress, ServerSocket>> list = new ArrayList<Map<InetAddress, ServerSocket>>(this.serverSockets);
        StringBuilder builder = new StringBuilder("");
        for (Map<InetAddress, ServerSocket> sockets : list) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(sockets.values().iterator().next().getLocalPort());
        }
        return "AvailablePortIterator{" + String.valueOf(this.inetAddresses) + ": " + builder.toString() + "}";
    }
}

