/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime.concurrent.runnable;

import com.oracle.bedrock.Option;
import com.oracle.bedrock.runtime.concurrent.RemoteRunnable;
import com.oracle.bedrock.runtime.java.JavaApplication;
import com.oracle.bedrock.runtime.options.ApplicationClosingBehavior;

public class RuntimeExit
implements RemoteRunnable,
ApplicationClosingBehavior<JavaApplication> {
    private int exitCode;

    public RuntimeExit() {
        this(0);
    }

    private RuntimeExit(int exitCode) {
        this.exitCode = exitCode;
    }

    @Override
    public void run() {
        System.out.println("Terminating Application using Runtime.exit(" + this.exitCode + ")");
        Runtime.getRuntime().exit(this.exitCode);
    }

    @Override
    public void onBeforeClosing(JavaApplication application, Option ... options) {
        try {
            application.submit(this, new Option[0]);
            application.waitFor(options);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RuntimeExit)) {
            return false;
        }
        RuntimeExit that = (RuntimeExit)other;
        return this.exitCode == that.exitCode;
    }

    public int hashCode() {
        return this.exitCode;
    }

    public static RuntimeExit withExitCode(int exitCode) {
        return new RuntimeExit(exitCode);
    }
}

