/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bedrock.runtime;

import com.oracle.bedrock.Bedrock;
import com.oracle.bedrock.Option;
import com.oracle.bedrock.OptionsByType;
import com.oracle.bedrock.annotations.Internal;
import com.oracle.bedrock.lang.StringHelper;
import com.oracle.bedrock.options.LaunchLogging;
import com.oracle.bedrock.runtime.Application;
import com.oracle.bedrock.runtime.ApplicationLauncher;
import com.oracle.bedrock.runtime.ApplicationListener;
import com.oracle.bedrock.runtime.LocalApplicationProcess;
import com.oracle.bedrock.runtime.MetaClass;
import com.oracle.bedrock.runtime.Platform;
import com.oracle.bedrock.runtime.Profile;
import com.oracle.bedrock.runtime.Profiles;
import com.oracle.bedrock.runtime.java.LocalProcessBuilder;
import com.oracle.bedrock.runtime.java.SimpleLocalProcessBuilder;
import com.oracle.bedrock.runtime.options.Arguments;
import com.oracle.bedrock.runtime.options.DisplayName;
import com.oracle.bedrock.runtime.options.EnvironmentVariables;
import com.oracle.bedrock.runtime.options.ErrorStreamRedirection;
import com.oracle.bedrock.runtime.options.Executable;
import com.oracle.bedrock.runtime.options.WorkingDirectory;
import com.oracle.bedrock.table.Row;
import com.oracle.bedrock.table.Table;
import com.oracle.bedrock.table.Tabularize;
import com.oracle.bedrock.util.ReflectionHelper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

@Internal
public class SimpleApplicationLauncher
implements ApplicationLauncher<Application> {
    private static final Logger LOGGER = Logger.getLogger(SimpleApplicationLauncher.class.getName());

    protected LocalProcessBuilder createProcessBuilder(String executable) {
        return new SimpleLocalProcessBuilder(executable);
    }

    @Override
    public Application launch(Platform platform, MetaClass<Application> metaClass, OptionsByType optionsByType) {
        Application application;
        Process process;
        Table diagnosticsTable = new Table(new Row[0]);
        diagnosticsTable.getOptions().add((Option)Table.orderByColumn((int)0));
        if (platform != null) {
            diagnosticsTable.addRow(new String[]{"Target Platform", platform.getName()});
        }
        OptionsByType launchOptions = OptionsByType.of((OptionsByType)platform.getOptions()).addAll(optionsByType);
        metaClass.onLaunching(platform, launchOptions);
        launchOptions.addAll(Profiles.getProfiles());
        for (Profile profile : launchOptions.getInstancesOf(Profile.class)) {
            profile.onLaunching(platform, metaClass, launchOptions);
        }
        metaClass.onLaunch(platform, launchOptions);
        DisplayName displayName = (DisplayName)launchOptions.getOrSetDefault(DisplayName.class, (Option)DisplayName.of(((Executable)launchOptions.get(Executable.class, new Object[0])).getName()));
        Executable executable = (Executable)launchOptions.get(Executable.class, new Object[0]);
        if (executable == null) {
            throw new IllegalArgumentException("Failed to define an Executable option");
        }
        LocalProcessBuilder processBuilder = this.createProcessBuilder(StringHelper.doubleQuoteIfNecessary((String)executable.getName()));
        WorkingDirectory workingDirectory = (WorkingDirectory)launchOptions.getOrSetDefault(WorkingDirectory.class, (Option)WorkingDirectory.currentDirectory());
        File directory = workingDirectory.resolve(platform, launchOptions);
        launchOptions.add((Option)WorkingDirectory.at(directory));
        if (directory != null) {
            processBuilder.directory(directory);
            diagnosticsTable.addRow(new String[]{"Working Directory", directory.toString()});
        }
        EnvironmentVariables environmentVariables = (EnvironmentVariables)launchOptions.get(EnvironmentVariables.class, new Object[0]);
        switch (environmentVariables.getSource()) {
            case Custom: {
                processBuilder.environment().clear();
                diagnosticsTable.addRow(new String[]{"Environment Variables", "(cleared)"});
                break;
            }
            case ThisApplication: {
                processBuilder.environment().clear();
                processBuilder.environment().putAll(System.getenv());
                diagnosticsTable.addRow(new String[]{"Environment Variables", "(based on parent process)"});
                break;
            }
            case TargetPlatform: {
                diagnosticsTable.addRow(new String[]{"Environment Variables", "(based on platform defaults)"});
            }
        }
        Properties variables = environmentVariables.realize(platform, launchOptions.asArray());
        for (String variableName : variables.stringPropertyNames()) {
            processBuilder.environment().put(variableName, variables.getProperty(variableName));
        }
        if (variables.size() > 0) {
            Table table = Tabularize.tabularize((Properties)variables);
            diagnosticsTable.addRow(new String[]{"", table.toString()});
        }
        List<String> command = processBuilder.command();
        List<String> arguments = ((Arguments)launchOptions.get(Arguments.class, new Object[0])).resolve(platform, launchOptions);
        command.addAll(arguments);
        diagnosticsTable.addRow(new String[]{"Application", displayName.resolve(launchOptions)});
        diagnosticsTable.addRow(new String[]{"Application Executable ", executable.getName()});
        if (arguments.size() > 0) {
            diagnosticsTable.addRow(new String[]{"Application Arguments ", arguments.stream().collect(Collectors.joining(" "))});
        }
        diagnosticsTable.addRow(new String[]{"Application Launch Time", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date())});
        launchOptions.add((Option)Arguments.of(arguments));
        ErrorStreamRedirection redirection = (ErrorStreamRedirection)launchOptions.get(ErrorStreamRedirection.class, new Object[0]);
        processBuilder.redirectErrorStream(redirection.isEnabled());
        boolean launchLogging = ((LaunchLogging)optionsByType.get(LaunchLogging.class, new Object[0])).isEnabled();
        if (launchLogging && LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Oracle Bedrock " + Bedrock.getVersion() + ": Starting Application...\n------------------------------------------------------------------------\n" + diagnosticsTable.toString() + "\n------------------------------------------------------------------------\n");
        }
        try {
            process = processBuilder.start(launchOptions);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to build the underlying native process for the application", e);
        }
        Class<Application> applicationClass = metaClass.getImplementationClass(platform, launchOptions);
        try {
            Constructor constructor = ReflectionHelper.getCompatibleConstructor(applicationClass, (Class[])new Class[]{platform.getClass(), LocalApplicationProcess.class, OptionsByType.class});
            application = (Application)constructor.newInstance(platform, new LocalApplicationProcess(process), launchOptions);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate the Application class specified by the MetaClass:" + String.valueOf(metaClass), e);
        }
        metaClass.onLaunched(platform, application, launchOptions);
        for (Profile profile : launchOptions.getInstancesOf(Profile.class)) {
            profile.onLaunched(platform, application, launchOptions);
        }
        for (ApplicationListener listener : launchOptions.getInstancesOf(ApplicationListener.class)) {
            listener.onLaunched(application);
        }
        return application;
    }
}

