/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVWriter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.concurrent.AccumulateCsvResults;
import com.opencsv.bean.concurrent.IntolerantThreadPoolExecutor;
import com.opencsv.bean.concurrent.OrderedObject;
import com.opencsv.bean.concurrent.ProcessCsvBean;
import com.opencsv.bean.opencsvUtils;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import com.opencsv.exceptions.CsvRuntimeException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class StatefulBeanToCsv<T> {
    private int lineNumber = 0;
    private final char separator;
    private final char quotechar;
    private final char escapechar;
    private final String lineEnd;
    private boolean headerWritten = false;
    private MappingStrategy<T> mappingStrategy;
    private final Writer writer;
    private CSVWriter csvwriter;
    private boolean throwExceptions;
    private List<CsvException> capturedExceptions = new ArrayList<CsvException>();
    private boolean orderedResults = true;
    private IntolerantThreadPoolExecutor executor = null;
    private BlockingQueue<OrderedObject<String[]>> resultantLineQueue;
    private BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue;
    private AccumulateCsvResults accumulateThread = null;
    private ConcurrentNavigableMap<Long, String[]> resultantBeansMap = null;
    private ConcurrentNavigableMap<Long, CsvException> thrownExceptionsMap = null;
    private Locale errorLocale = Locale.getDefault();

    private StatefulBeanToCsv() {
        throw new IllegalStateException(String.format(ResourceBundle.getBundle("opencsv").getString("nullary.constructor.not.allowed"), this.getClass().getName()));
    }

    public StatefulBeanToCsv(char escapechar, String lineEnd, MappingStrategy<T> mappingStrategy, char quotechar, char separator, boolean throwExceptions, Writer writer) {
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
        this.mappingStrategy = mappingStrategy;
        this.quotechar = quotechar;
        this.separator = separator;
        this.throwExceptions = throwExceptions;
        this.writer = writer;
    }

    private void beforeFirstWrite(T bean) {
        if (this.mappingStrategy == null) {
            this.mappingStrategy = opencsvUtils.determineMappingStrategy(bean.getClass(), this.errorLocale);
        }
        this.csvwriter = new CSVWriter(this.writer, this.separator, this.quotechar, this.escapechar, this.lineEnd);
        String[] header = this.mappingStrategy.generateHeader();
        if (header.length > 0) {
            this.csvwriter.writeNext(header);
        }
        this.headerWritten = true;
    }

    public void write(T bean) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        if (bean != null) {
            if (!this.headerWritten) {
                this.beforeFirstWrite(bean);
            }
            this.resultantLineQueue = new ArrayBlockingQueue<OrderedObject<String[]>>(1);
            this.thrownExceptionsQueue = new ArrayBlockingQueue<OrderedObject<CsvException>>(1);
            ProcessCsvBean<T> proc = new ProcessCsvBean<T>(++this.lineNumber, this.mappingStrategy, bean, this.resultantLineQueue, this.thrownExceptionsQueue, this.throwExceptions, this.errorLocale);
            try {
                proc.run();
            }
            catch (RuntimeException re) {
                if (re.getCause() != null) {
                    if (re.getCause() instanceof CsvRuntimeException) {
                        CsvRuntimeException csve = (CsvRuntimeException)re.getCause();
                        throw csve;
                    }
                    if (re.getCause() instanceof CsvDataTypeMismatchException) {
                        CsvDataTypeMismatchException csve = (CsvDataTypeMismatchException)re.getCause();
                        throw csve;
                    }
                    if (re.getCause() instanceof CsvRequiredFieldEmptyException) {
                        CsvRequiredFieldEmptyException csve = (CsvRequiredFieldEmptyException)re.getCause();
                        throw csve;
                    }
                }
                throw re;
            }
            if (!this.thrownExceptionsQueue.isEmpty()) {
                OrderedObject o = (OrderedObject)this.thrownExceptionsQueue.poll();
                if (o != null && o.getElement() != null) {
                    this.capturedExceptions.add((CsvException)o.getElement());
                }
            } else {
                OrderedObject result = (OrderedObject)this.resultantLineQueue.poll();
                if (result != null && result.getElement() != null) {
                    this.csvwriter.writeNext((String[])result.getElement());
                }
            }
        }
    }

    private void prepareForParallelProcessing() {
        this.executor = new IntolerantThreadPoolExecutor();
        this.executor.prestartAllCoreThreads();
        this.resultantLineQueue = new LinkedBlockingQueue<OrderedObject<String[]>>();
        this.thrownExceptionsQueue = new LinkedBlockingQueue<OrderedObject<CsvException>>();
        if (this.orderedResults) {
            this.resultantBeansMap = new ConcurrentSkipListMap<Long, String[]>();
            this.thrownExceptionsMap = new ConcurrentSkipListMap<Long, CsvException>();
            this.accumulateThread = new AccumulateCsvResults<String[]>(this.resultantLineQueue, this.thrownExceptionsQueue, this.resultantBeansMap, this.thrownExceptionsMap);
            this.accumulateThread.start();
        }
    }

    private void submitAllLines(List<T> beans) throws InterruptedException {
        for (T bean : beans) {
            if (bean == null) continue;
            this.executor.execute(new ProcessCsvBean<T>(++this.lineNumber, this.mappingStrategy, bean, this.resultantLineQueue, this.thrownExceptionsQueue, this.throwExceptions, this.errorLocale));
        }
        this.executor.shutdown();
        this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        if (this.accumulateThread != null) {
            this.accumulateThread.setMustStop(true);
            this.accumulateThread.join();
        }
        if (this.executor.getTerminalException() != null) {
            throw new RejectedExecutionException();
        }
    }

    private void writeResultsOfParallelProcessingToFile() {
        if (this.thrownExceptionsMap != null && this.resultantBeansMap != null) {
            this.capturedExceptions = new ArrayList(this.thrownExceptionsMap.values());
            for (String[] oneLine : this.resultantBeansMap.values()) {
                this.csvwriter.writeNext(oneLine);
            }
        } else {
            this.capturedExceptions = new ArrayList<CsvException>(this.thrownExceptionsQueue.size());
            while (!this.thrownExceptionsQueue.isEmpty()) {
                OrderedObject oocsve = (OrderedObject)this.thrownExceptionsQueue.poll();
                if (oocsve == null || oocsve.getElement() == null) continue;
                this.capturedExceptions.add((CsvException)oocsve.getElement());
            }
            while (!this.resultantLineQueue.isEmpty()) {
                try {
                    OrderedObject<String[]> ooresult = this.resultantLineQueue.take();
                    this.csvwriter.writeNext(ooresult.getElement());
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void write(List<T> beans) throws CsvDataTypeMismatchException, CsvRequiredFieldEmptyException {
        if (CollectionUtils.isNotEmpty(beans)) {
            if (!this.headerWritten) {
                this.beforeFirstWrite(beans.get(0));
            }
            this.prepareForParallelProcessing();
            try {
                this.submitAllLines(beans);
            }
            catch (RejectedExecutionException e) {
                if (this.accumulateThread != null) {
                    this.accumulateThread.setMustStop(true);
                }
                if (this.executor.getTerminalException() instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)this.executor.getTerminalException();
                    throw re;
                }
                if (this.executor.getTerminalException() instanceof CsvDataTypeMismatchException) {
                    CsvDataTypeMismatchException csve = (CsvDataTypeMismatchException)this.executor.getTerminalException();
                    throw csve;
                }
                if (this.executor.getTerminalException() instanceof CsvRequiredFieldEmptyException) {
                    CsvRequiredFieldEmptyException csve = (CsvRequiredFieldEmptyException)this.executor.getTerminalException();
                    throw csve;
                }
                throw new RuntimeException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("error.writing.beans"), this.executor.getTerminalException());
            }
            catch (Exception e) {
                this.executor.shutdownNow();
                if (this.accumulateThread != null) {
                    this.accumulateThread.setMustStop(true);
                }
                if (this.executor.getTerminalException() instanceof RuntimeException) {
                    RuntimeException re = (RuntimeException)this.executor.getTerminalException();
                    throw re;
                }
                throw new RuntimeException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("error.writing.beans"), e);
            }
            this.writeResultsOfParallelProcessingToFile();
        }
    }

    public void setOrderedResults(boolean orderedResults) {
        this.orderedResults = orderedResults;
    }

    public boolean isThrowExceptions() {
        return this.throwExceptions;
    }

    public List<CsvException> getCapturedExceptions() {
        List<CsvException> intermediate = this.capturedExceptions;
        this.capturedExceptions = new ArrayList<CsvException>();
        return intermediate;
    }

    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = (Locale)ObjectUtils.defaultIfNull((Object)errorLocale, (Object)Locale.getDefault());
    }
}

