/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.iterable;

import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.rdb.RdbListener;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueModule;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyStringValueString;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyValuePair;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.datatype.ZSetEntry;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueByteArrayIterator;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueMapEntryIterator;
import com.moilioncircle.redis.replicator.rdb.iterable.datatype.KeyStringValueZSetEntryIterator;
import com.moilioncircle.redis.replicator.util.ByteArrayMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ValueIterableRdbListener
extends RdbListener.Adaptor {
    private int batchSize;
    private boolean order;

    public ValueIterableRdbListener() {
        this(64);
    }

    public ValueIterableRdbListener(int batchSize) {
        this(true, batchSize);
    }

    public ValueIterableRdbListener(boolean order, int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException(String.valueOf(batchSize));
        }
        this.order = order;
        this.batchSize = batchSize;
    }

    public void handleString(KeyValuePair<byte[]> kv, int batch, boolean last) {
        throw new UnsupportedOperationException("must implement this method.");
    }

    public void handleList(KeyValuePair<List<byte[]>> kv, int batch, boolean last) {
        throw new UnsupportedOperationException("must implement this method.");
    }

    public void handleSet(KeyValuePair<Set<byte[]>> kv, int batch, boolean last) {
        throw new UnsupportedOperationException("must implement this method.");
    }

    public void handleMap(KeyValuePair<Map<byte[], byte[]>> kv, int batch, boolean last) {
        throw new UnsupportedOperationException("must implement this method.");
    }

    public void handleZSetEntry(KeyValuePair<Set<ZSetEntry>> kv, int batch, boolean last) {
        throw new UnsupportedOperationException("must implement this method.");
    }

    public void handleModule(KeyValuePair<Module> kv, int batch, boolean last) {
        throw new UnsupportedOperationException("must implement this method.");
    }

    @Override
    public void handle(Replicator replicator, KeyValuePair<?> kv) {
        int batch = 0;
        int type = kv.getValueRdbType();
        if (kv instanceof KeyStringValueString) {
            KeyStringValueString ksvs = (KeyStringValueString)kv;
            this.handleString(this.create(kv, ksvs.getRawValue()), batch, true);
        } else if (kv instanceof KeyStringValueByteArrayIterator) {
            if (type == 2 || type == 11) {
                Iterator it = (Iterator)((KeyStringValueByteArrayIterator)kv).getValue();
                Set prev = null;
                Set next = this.create(this.order, this.batchSize);
                while (it.hasNext()) {
                    next.add(it.next());
                    if (next.size() != this.batchSize) continue;
                    if (prev != null) {
                        this.handleSet(this.create(kv, prev), batch++, false);
                    }
                    prev = next;
                    next = this.create(this.order, this.batchSize);
                }
                boolean last = next.isEmpty();
                this.handleSet(this.create(kv, prev), batch++, last);
                if (!last) {
                    this.handleSet(this.create(kv, next), batch++, true);
                }
            } else {
                Iterator it = (Iterator)((KeyStringValueByteArrayIterator)kv).getValue();
                ArrayList prev = null;
                ArrayList next = new ArrayList(this.batchSize);
                while (it.hasNext()) {
                    try {
                        next.add(it.next());
                        if (next.size() != this.batchSize) continue;
                        if (prev != null) {
                            this.handleList(this.create(kv, prev), batch++, false);
                        }
                        prev = next;
                        next = new ArrayList(this.batchSize);
                    }
                    catch (IllegalStateException last) {}
                }
                boolean last = next.isEmpty();
                this.handleList(this.create(kv, prev), batch++, last);
                if (!last) {
                    this.handleList(this.create(kv, next), batch++, true);
                }
            }
        } else if (kv instanceof KeyStringValueMapEntryIterator) {
            Iterator it = (Iterator)((KeyStringValueMapEntryIterator)kv).getValue();
            ByteArrayMap prev = null;
            ByteArrayMap next = new ByteArrayMap(this.order, this.batchSize);
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                next.put(entry.getKey(), entry.getValue());
                if (next.size() != this.batchSize) continue;
                if (prev != null) {
                    this.handleMap(this.create(kv, prev), batch++, false);
                }
                prev = next;
                next = new ByteArrayMap(this.order, this.batchSize);
            }
            boolean last = next.isEmpty();
            this.handleMap(this.create(kv, prev), batch++, last);
            if (!last) {
                this.handleMap(this.create(kv, next), batch++, true);
            }
        } else if (kv instanceof KeyStringValueZSetEntryIterator) {
            Iterator it = (Iterator)((KeyStringValueZSetEntryIterator)kv).getValue();
            Set prev = null;
            Set next = this.create(this.order, this.batchSize);
            while (it.hasNext()) {
                next.add(it.next());
                if (next.size() != this.batchSize) continue;
                if (prev != null) {
                    this.handleZSetEntry(this.create(kv, prev), batch++, false);
                }
                prev = next;
                next = this.create(this.order, this.batchSize);
            }
            boolean last = next.isEmpty();
            this.handleZSetEntry(this.create(kv, prev), batch++, last);
            if (!last) {
                this.handleZSetEntry(this.create(kv, next), batch++, true);
            }
        } else if (kv instanceof KeyStringValueModule) {
            this.handleModule((KeyStringValueModule)kv, batch, true);
        }
    }

    private <T> Set<T> create(boolean order, int batchSize) {
        return order ? new LinkedHashSet(batchSize) : new HashSet(batchSize);
    }

    private <T> KeyValuePair<T> create(KeyValuePair<?> raw, T value) {
        KeyValuePair<T> kv = new KeyValuePair<T>();
        kv.setDb(raw.getDb());
        kv.setExpiredType(raw.getExpiredType());
        kv.setExpiredValue(raw.getExpiredValue());
        kv.setValueRdbType(raw.getValueRdbType());
        kv.setKey(raw.getKey());
        kv.setRawKey(raw.getRawKey());
        kv.setValue(value);
        return kv;
    }
}

