/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator.rdb.dump;

import com.moilioncircle.redis.replicator.Constants;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.event.Event;
import com.moilioncircle.redis.replicator.io.RawByteListener;
import com.moilioncircle.redis.replicator.io.RedisInputStream;
import com.moilioncircle.redis.replicator.rdb.BaseRdbParser;
import com.moilioncircle.redis.replicator.rdb.DefaultRdbVisitor;
import com.moilioncircle.redis.replicator.rdb.datatype.DB;
import com.moilioncircle.redis.replicator.rdb.datatype.Module;
import com.moilioncircle.redis.replicator.rdb.dump.datatype.DumpKeyValuePair;
import com.moilioncircle.redis.replicator.rdb.module.ModuleParser;
import com.moilioncircle.redis.replicator.rdb.skip.SkipRdbParser;
import com.moilioncircle.redis.replicator.util.ByteBuilder;
import com.moilioncircle.redis.replicator.util.CRC64;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;

public class DumpRdbVisitor
extends DefaultRdbVisitor {
    private final int size;
    private final int version;

    public DumpRdbVisitor(Replicator replicator) {
        this(replicator, -1, 8192);
    }

    public DumpRdbVisitor(Replicator replicator, int version, int size) {
        super(replicator);
        this.version = version;
        this.size = size;
    }

    @Override
    public Event applyString(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o0 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(0, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadEncodedStringObject();
        this.replicator.removeRawByteListener(listener);
        o0.setValueRdbType(0);
        o0.setValue(listener.getBytes());
        o0.setDb(db);
        o0.setKey(new String(key, StandardCharsets.UTF_8));
        o0.setRawKey(key);
        return o0;
    }

    @Override
    public Event applyList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o1 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(1, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        long len = skipParser.rdbLoadLen().len;
        int i = 0;
        while ((long)i < len) {
            skipParser.rdbLoadEncodedStringObject();
            ++i;
        }
        this.replicator.removeRawByteListener(listener);
        o1.setValueRdbType(1);
        o1.setValue(listener.getBytes());
        o1.setDb(db);
        o1.setKey(new String(key, StandardCharsets.UTF_8));
        o1.setRawKey(key);
        return o1;
    }

    @Override
    public Event applySet(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o2 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(2, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        long len = skipParser.rdbLoadLen().len;
        int i = 0;
        while ((long)i < len) {
            skipParser.rdbLoadEncodedStringObject();
            ++i;
        }
        this.replicator.removeRawByteListener(listener);
        o2.setValueRdbType(2);
        o2.setValue(listener.getBytes());
        o2.setDb(db);
        o2.setKey(new String(key, StandardCharsets.UTF_8));
        o2.setRawKey(key);
        return o2;
    }

    @Override
    public Event applyZSet(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o3 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(3, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
            skipParser.rdbLoadEncodedStringObject();
            skipParser.rdbLoadDoubleValue();
        }
        this.replicator.removeRawByteListener(listener);
        o3.setValueRdbType(3);
        o3.setValue(listener.getBytes());
        o3.setDb(db);
        o3.setKey(new String(key, StandardCharsets.UTF_8));
        o3.setRawKey(key);
        return o3;
    }

    @Override
    public Event applyZSet2(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o5 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(5, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
            skipParser.rdbLoadEncodedStringObject();
            skipParser.rdbLoadBinaryDoubleValue();
        }
        this.replicator.removeRawByteListener(listener);
        o5.setValueRdbType(5);
        o5.setValue(listener.getBytes());
        o5.setDb(db);
        o5.setKey(new String(key, StandardCharsets.UTF_8));
        o5.setRawKey(key);
        return o5;
    }

    @Override
    public Event applyHash(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o4 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(4, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        for (long len = skipParser.rdbLoadLen().len; len > 0L; --len) {
            skipParser.rdbLoadEncodedStringObject();
            skipParser.rdbLoadEncodedStringObject();
        }
        this.replicator.removeRawByteListener(listener);
        o4.setValueRdbType(4);
        o4.setValue(listener.getBytes());
        o4.setDb(db);
        o4.setKey(new String(key, StandardCharsets.UTF_8));
        o4.setRawKey(key);
        return o4;
    }

    @Override
    public Event applyHashZipMap(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o9 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(9, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        o9.setValueRdbType(9);
        o9.setValue(listener.getBytes());
        o9.setDb(db);
        o9.setKey(new String(key, StandardCharsets.UTF_8));
        o9.setRawKey(key);
        return o9;
    }

    @Override
    public Event applyListZipList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o10 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(10, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        o10.setValueRdbType(10);
        o10.setValue(listener.getBytes());
        o10.setDb(db);
        o10.setKey(new String(key, StandardCharsets.UTF_8));
        o10.setRawKey(key);
        return o10;
    }

    @Override
    public Event applySetIntSet(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o11 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(11, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        o11.setValueRdbType(11);
        o11.setValue(listener.getBytes());
        o11.setDb(db);
        o11.setKey(new String(key, StandardCharsets.UTF_8));
        o11.setRawKey(key);
        return o11;
    }

    @Override
    public Event applyZSetZipList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o12 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(12, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        o12.setValueRdbType(12);
        o12.setValue(listener.getBytes());
        o12.setDb(db);
        o12.setKey(new String(key, StandardCharsets.UTF_8));
        o12.setRawKey(key);
        return o12;
    }

    @Override
    public Event applyHashZipList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o13 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(13, version);
        this.replicator.addRawByteListener(listener);
        new SkipRdbParser(in).rdbLoadPlainStringObject();
        this.replicator.removeRawByteListener(listener);
        o13.setValueRdbType(13);
        o13.setValue(listener.getBytes());
        o13.setDb(db);
        o13.setKey(new String(key, StandardCharsets.UTF_8));
        o13.setRawKey(key);
        return o13;
    }

    @Override
    public Event applyListQuickList(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o14 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(14, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        long len = skipParser.rdbLoadLen().len;
        int i = 0;
        while ((long)i < len) {
            skipParser.rdbGenericLoadStringObject();
            ++i;
        }
        this.replicator.removeRawByteListener(listener);
        o14.setValueRdbType(14);
        o14.setValue(listener.getBytes());
        o14.setDb(db);
        o14.setKey(new String(key, StandardCharsets.UTF_8));
        o14.setRawKey(key);
        return o14;
    }

    @Override
    public Event applyModule(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o6 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(6, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        char[] c = new char[9];
        long moduleid = skipParser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        if (moduleParser == null) {
            throw new NoSuchElementException("module[" + moduleName + "," + moduleVersion + "] not exist.");
        }
        moduleParser.parse(in, 1);
        this.replicator.removeRawByteListener(listener);
        o6.setValueRdbType(6);
        o6.setValue(listener.getBytes());
        o6.setDb(db);
        o6.setKey(new String(key, StandardCharsets.UTF_8));
        o6.setRawKey(key);
        return o6;
    }

    @Override
    public Event applyModule2(RedisInputStream in, DB db, int version) throws IOException {
        BaseRdbParser parser = new BaseRdbParser(in);
        DumpKeyValuePair o7 = new DumpKeyValuePair();
        byte[] key = parser.rdbLoadEncodedStringObject().first();
        DefaultRawByteListener listener = new DefaultRawByteListener(7, version);
        this.replicator.addRawByteListener(listener);
        SkipRdbParser skipParser = new SkipRdbParser(in);
        char[] c = new char[9];
        long moduleid = skipParser.rdbLoadLen().len;
        for (int i = 0; i < c.length; ++i) {
            c[i] = Constants.MODULE_SET[(int)(moduleid >>> 10 + (c.length - 1 - i) * 6 & 0x3FL)];
        }
        String moduleName = new String(c);
        int moduleVersion = (int)(moduleid & 0x3FFL);
        ModuleParser<? extends Module> moduleParser = this.lookupModuleParser(moduleName, moduleVersion);
        if (moduleParser == null) {
            throw new NoSuchElementException("module[" + moduleName + "," + moduleVersion + "] not exist.");
        }
        moduleParser.parse(in, 2);
        long eof = skipParser.rdbLoadLen().len;
        if (eof != 0L) {
            throw new UnsupportedOperationException("The RDB file contains module data for the module '" + moduleName + "' that is not terminated by the proper module value EOF marker");
        }
        this.replicator.removeRawByteListener(listener);
        o7.setValueRdbType(7);
        o7.setValue(listener.getBytes());
        o7.setDb(db);
        o7.setKey(new String(key, StandardCharsets.UTF_8));
        o7.setRawKey(key);
        return o7;
    }

    private class DefaultRawByteListener
    implements RawByteListener {
        private final int version;
        private final ByteBuilder builder;

        private DefaultRawByteListener(byte type, int version) {
            this.builder = ByteBuilder.allocate(DumpRdbVisitor.this.size);
            this.builder.put(type);
            int ver = DumpRdbVisitor.this.version;
            this.version = ver == -1 ? version : ver;
        }

        @Override
        public void handle(byte ... rawBytes) {
            for (byte b : rawBytes) {
                this.builder.put(b);
            }
        }

        public byte[] getBytes() {
            byte[] crc;
            this.builder.put((byte)this.version);
            this.builder.put((byte)0);
            byte[] bytes = this.builder.array();
            for (byte b : crc = CRC64.longToByteArray(CRC64.crc64(bytes))) {
                this.builder.put(b);
            }
            return this.builder.array();
        }
    }
}

