/*
 * Decompiled with CFR 0.152.
 */
package com.moilioncircle.redis.replicator;

import com.moilioncircle.redis.replicator.CloseListener;
import com.moilioncircle.redis.replicator.ExceptionListener;
import com.moilioncircle.redis.replicator.Replicator;
import com.moilioncircle.redis.replicator.ReplicatorListener;
import com.moilioncircle.redis.replicator.cmd.Command;
import com.moilioncircle.redis.replicator.cmd.CommandListener;
import com.moilioncircle.redis.replicator.io.RawByteListener;
import com.moilioncircle.redis.replicator.rdb.AuxFieldListener;
import com.moilioncircle.redis.replicator.rdb.RdbListener;
import com.moilioncircle.redis.replicator.rdb.datatype.AuxField;
import com.moilioncircle.redis.replicator.rdb.datatype.KeyValuePair;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AbstractReplicatorListener
implements ReplicatorListener {
    protected final List<RdbListener> rdbListeners = new CopyOnWriteArrayList<RdbListener>();
    protected final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();
    protected final List<CommandListener> commandListeners = new CopyOnWriteArrayList<CommandListener>();
    protected final List<RawByteListener> rawByteListeners = new CopyOnWriteArrayList<RawByteListener>();
    protected final List<AuxFieldListener> auxFieldListeners = new CopyOnWriteArrayList<AuxFieldListener>();
    protected final List<ExceptionListener> exceptionListeners = new CopyOnWriteArrayList<ExceptionListener>();

    @Override
    public boolean addCommandListener(CommandListener listener) {
        return this.commandListeners.add(listener);
    }

    @Override
    public boolean removeCommandListener(CommandListener listener) {
        return this.commandListeners.remove(listener);
    }

    @Override
    public boolean addRdbListener(RdbListener listener) {
        return this.rdbListeners.add(listener);
    }

    @Override
    public boolean removeRdbListener(RdbListener listener) {
        return this.rdbListeners.remove(listener);
    }

    @Override
    public boolean addAuxFieldListener(AuxFieldListener listener) {
        return this.auxFieldListeners.add(listener);
    }

    @Override
    public boolean removeAuxFieldListener(AuxFieldListener listener) {
        return this.auxFieldListeners.remove(listener);
    }

    @Override
    public boolean addRawByteListener(RawByteListener listener) {
        return this.rawByteListeners.add(listener);
    }

    @Override
    public boolean removeRawByteListener(RawByteListener listener) {
        return this.rawByteListeners.remove(listener);
    }

    @Override
    public boolean addCloseListener(CloseListener listener) {
        return this.closeListeners.add(listener);
    }

    @Override
    public boolean removeCloseListener(CloseListener listener) {
        return this.closeListeners.remove(listener);
    }

    @Override
    public boolean addExceptionListener(ExceptionListener listener) {
        return this.exceptionListeners.add(listener);
    }

    @Override
    public boolean removeExceptionListener(ExceptionListener listener) {
        return this.exceptionListeners.remove(listener);
    }

    @Deprecated
    public void handle(byte ... rawBytes) {
        this.doRawByteListener(rawBytes);
    }

    protected void doCommandListener(Replicator replicator, Command command) {
        if (this.commandListeners.isEmpty()) {
            return;
        }
        for (CommandListener listener : this.commandListeners) {
            listener.handle(replicator, command);
        }
    }

    protected void doRdbListener(Replicator replicator, KeyValuePair<?> kv) {
        if (this.rdbListeners.isEmpty()) {
            return;
        }
        for (RdbListener listener : this.rdbListeners) {
            listener.handle(replicator, kv);
        }
    }

    protected void doAuxFieldListener(Replicator replicator, AuxField auxField) {
        if (this.auxFieldListeners.isEmpty()) {
            return;
        }
        for (AuxFieldListener listener : this.auxFieldListeners) {
            listener.handle(replicator, auxField);
        }
    }

    protected void doPreFullSync(Replicator replicator) {
        if (this.rdbListeners.isEmpty()) {
            return;
        }
        for (RdbListener listener : this.rdbListeners) {
            listener.preFullSync(replicator);
        }
    }

    protected void doPostFullSync(Replicator replicator, long checksum) {
        if (this.rdbListeners.isEmpty()) {
            return;
        }
        for (RdbListener listener : this.rdbListeners) {
            listener.postFullSync(replicator, checksum);
        }
    }

    protected void doCloseListener(Replicator replicator) {
        if (this.closeListeners.isEmpty()) {
            return;
        }
        for (CloseListener listener : this.closeListeners) {
            listener.handle(replicator);
        }
    }

    protected void doExceptionListener(Replicator replicator, Throwable throwable, Object event) {
        if (this.exceptionListeners.isEmpty()) {
            return;
        }
        for (ExceptionListener listener : this.exceptionListeners) {
            listener.handle(replicator, throwable, event);
        }
    }

    protected void doRawByteListener(byte ... bytes) {
        if (this.rawByteListeners.isEmpty()) {
            return;
        }
        for (RawByteListener listener : this.rawByteListeners) {
            listener.handle(bytes);
        }
    }
}

