/*
 * Decompiled with CFR 0.152.
 */
package com.klarna.hiverunner.sql.split;

import com.klarna.hiverunner.sql.split.Consumer;
import com.klarna.hiverunner.sql.split.Context;
import com.klarna.hiverunner.sql.split.TokenRule;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;

public enum PreserveCommentsRule implements TokenRule
{
    INSTANCE;

    static final Pattern START_OF_COMMENT_PATTERN;

    @Override
    public Set<String> triggers() {
        return Collections.singleton("-");
    }

    @Override
    public void handle(String token, Context context) {
        context.append(token);
        if (START_OF_COMMENT_PATTERN.matcher(context.statement()).matches()) {
            context.appendWith(Consumer.UNTIL_EOL);
        }
    }

    static {
        START_OF_COMMENT_PATTERN = Pattern.compile(".*\\s--", 32);
    }
}

