/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.redis;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.redis.Cache;
import com.jfinal.plugin.redis.ICallback;
import java.util.concurrent.ConcurrentHashMap;
import redis.clients.jedis.Jedis;

public class Redis {
    static Cache mainCache = null;
    private static final ConcurrentHashMap<String, Cache> cacheMap = new ConcurrentHashMap();

    static synchronized void addCache(Cache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache can not be null");
        }
        if (cacheMap.containsKey(cache.getName())) {
            throw new IllegalArgumentException("cache already exists");
        }
        cacheMap.put(cache.getName(), cache);
        if (mainCache == null) {
            mainCache = cache;
        }
    }

    static Cache removeCache(String cacheName) {
        return cacheMap.remove(cacheName);
    }

    public static void setMainCache(String cacheName) {
        if (StrKit.isBlank(cacheName)) {
            throw new IllegalArgumentException("cacheName can not be blank");
        }
        Cache cache = cacheMap.get(cacheName = cacheName.trim());
        if (cache == null) {
            throw new IllegalArgumentException("the cache not exists: " + cacheName);
        }
        mainCache = cache;
    }

    public static Cache use() {
        return mainCache;
    }

    public static Cache use(String cacheName) {
        return cacheMap.get(cacheName);
    }

    public static Object call(ICallback callback) {
        return Redis.call(callback, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object call(ICallback callback, String cacheName) {
        boolean notThreadLocalJedis;
        Cache cache = cacheName != null ? Redis.use(cacheName) : Redis.use();
        Jedis jedis = cache.getThreadLocalJedis();
        boolean bl = notThreadLocalJedis = jedis == null;
        if (notThreadLocalJedis) {
            jedis = cache.jedisPool.getResource();
            cache.setThreadLocalJedis(jedis);
        }
        try {
            Object t = callback.call(cache);
            return t;
        }
        finally {
            if (notThreadLocalJedis) {
                cache.removeThreadLocalJedis();
                jedis.close();
            }
        }
    }
}

