/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.redis;

import com.jfinal.plugin.redis.IKeyNamingPolicy;
import com.jfinal.plugin.redis.serializer.ISerializer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class Cache {
    final String name;
    final JedisPool jedisPool;
    final ISerializer serializer;
    final IKeyNamingPolicy keyNamingPolicy;
    private final ThreadLocal<Jedis> threadLocalJedis = new ThreadLocal();

    Cache(String name, JedisPool jedisPool, ISerializer serializer, IKeyNamingPolicy keyNamingPolicy) {
        this.name = name;
        this.jedisPool = jedisPool;
        this.serializer = serializer;
        this.keyNamingPolicy = keyNamingPolicy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(Object key, Object value) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.set(this.keyToBytes(key), this.valueToBytes(value));
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setex(Object key, int seconds, Object value) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.setex(this.keyToBytes(key), seconds, this.valueToBytes(value));
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.get(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.del(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long del(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.del(this.keysToBytesArray(keys));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keys(String pattern) {
        Jedis jedis = this.getJedis();
        try {
            Set set = jedis.keys(pattern);
            return set;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String mset(Object ... keysValues) {
        if (keysValues.length % 2 != 0) {
            throw new IllegalArgumentException("wrong number of arguments for met, keysValues length can not be odd");
        }
        Jedis jedis = this.getJedis();
        try {
            byte[][] kv = new byte[keysValues.length][];
            for (int i = 0; i < keysValues.length; ++i) {
                kv[i] = i % 2 == 0 ? this.keyToBytes(keysValues[i]) : this.valueToBytes(keysValues[i]);
            }
            String string = jedis.mset((byte[][])kv);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List mget(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            byte[][] keysBytesArray = this.keysToBytesArray(keys);
            List data = jedis.mget(keysBytesArray);
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long decr(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.decr(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long decrBy(Object key, long longValue) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.decrBy(this.keyToBytes(key), longValue);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incr(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.incr(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long incrBy(Object key, long longValue) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.incrBy(this.keyToBytes(key), longValue);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(Object key) {
        Jedis jedis = this.getJedis();
        try {
            boolean bl = jedis.exists(this.keyToBytes(key));
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String randomKey() {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.randomKey();
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rename(Object oldkey, Object newkey) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.rename(this.keyToBytes(oldkey), this.keyToBytes(newkey));
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long move(Object key, int dbIndex) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.move(this.keyToBytes(key), dbIndex);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String migrate(String host, int port, Object key, int destinationDb, int timeout) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.migrate(this.valueToBytes(host), port, this.keyToBytes(key), destinationDb, timeout);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String select(int databaseIndex) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.select(databaseIndex);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expire(Object key, int seconds) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.expire(this.keyToBytes(key), seconds);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long expireAt(Object key, long unixTime) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.expireAt(this.keyToBytes(key), unixTime);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pexpire(Object key, long milliseconds) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.pexpire(this.keyToBytes(key), milliseconds);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pexpireAt(Object key, long millisecondsTimestamp) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.pexpireAt(this.keyToBytes(key), millisecondsTimestamp);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getSet(Object key, Object value) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.getSet(this.keyToBytes(key), this.valueToBytes(value)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long persist(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.persist(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String type(Object key) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.type(this.keyToBytes(key));
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long ttl(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.ttl(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long pttl(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.pttl(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long objectRefcount(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.objectRefcount(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long objectIdletime(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.objectIdletime(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hset(Object key, Object field, Object value) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.hset(this.keyToBytes(key), this.keyToBytes(field), this.valueToBytes(value));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String hmset(Object key, Map<Object, Object> hash) {
        Jedis jedis = this.getJedis();
        try {
            HashMap<byte[], byte[]> para = new HashMap<byte[], byte[]>();
            for (Map.Entry<Object, Object> e : hash.entrySet()) {
                para.put(this.keyToBytes(e.getKey()), this.valueToBytes(e.getValue()));
            }
            String string = jedis.hmset(this.keyToBytes(key), para);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T hget(Object key, Object field) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.hget(this.keyToBytes(key), this.keyToBytes(field)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List hmget(Object key, Object ... fields) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.hmget(this.keyToBytes(key), this.keysToBytesArray(fields));
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hdel(Object key, Object ... fields) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.hdel(this.keyToBytes(key), this.keysToBytesArray(fields));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hexists(Object key, Object field) {
        Jedis jedis = this.getJedis();
        try {
            boolean bl = jedis.hexists(this.keyToBytes(key), this.keyToBytes(field));
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map hgetAll(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Map data = jedis.hgetAll(this.keyToBytes(key));
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Map.Entry e : data.entrySet()) {
                result.put(this.keyFromBytes((byte[])e.getKey()), this.valueFromBytes((byte[])e.getValue()));
            }
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List hvals(Object key) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.hvals(this.keyToBytes(key));
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> hkeys(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Set keySet = jedis.hkeys(this.keyToBytes(key));
            Set<String> set = this.keySetFromBytesSet(keySet);
            return set;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long hlen(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.hlen(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T lindex(Object key, long index) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.lindex(this.keyToBytes(key), index));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getCounter(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = Long.parseLong(jedis.get(this.keyNamingPolicy.getKeyName(key)));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long llen(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.llen(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T lpop(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.lpop(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lpush(Object key, Object ... values) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.lpush(this.keyToBytes(key), this.valuesToBytesArray(values));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String lset(Object key, long index, Object value) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.lset(this.keyToBytes(key), index, this.valueToBytes(value));
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long lrem(Object key, long count, Object value) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.lrem(this.keyToBytes(key), count, this.valueToBytes(value));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List lrange(Object key, long start, long end) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.lrange(this.keyToBytes(key), start, end);
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ltrim(Object key, long start, long end) {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.ltrim(this.keyToBytes(key), start, end);
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T rpop(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.rpop(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T rpoplpush(Object srcKey, Object dstKey) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.rpoplpush(this.keyToBytes(srcKey), this.keyToBytes(dstKey)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long rpush(Object key, Object ... values) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.rpush(this.keyToBytes(key), this.valuesToBytesArray(values));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List blpop(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.blpop(this.keysToBytesArray(keys));
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List blpop(int timeout, Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.blpop(timeout, this.keysToBytesArray(keys));
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List brpop(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.brpop(this.keysToBytesArray(keys));
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List brpop(int timeout, Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.brpop(timeout, this.keysToBytesArray(keys));
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String ping() {
        Jedis jedis = this.getJedis();
        try {
            String string = jedis.ping();
            return string;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long sadd(Object key, Object ... members) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.sadd(this.keyToBytes(key), this.valuesToBytesArray(members));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long scard(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.scard(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T spop(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.spop(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set smembers(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.smembers(this.keyToBytes(key));
            HashSet<Object> result = new HashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sismember(Object key, Object member) {
        Jedis jedis = this.getJedis();
        try {
            boolean bl = jedis.sismember(this.keyToBytes(key), this.valueToBytes(member));
            return bl;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set sinter(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.sinter(this.keysToBytesArray(keys));
            HashSet<Object> result = new HashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T srandmember(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Object object = this.valueFromBytes(jedis.srandmember(this.keyToBytes(key)));
            return (T)object;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List srandmember(Object key, int count) {
        Jedis jedis = this.getJedis();
        try {
            List data = jedis.srandmember(this.keyToBytes(key), count);
            List list = this.valueListFromBytesList(data);
            return list;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long srem(Object key, Object ... members) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.srem(this.keyToBytes(key), this.valuesToBytesArray(members));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set sunion(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.sunion(this.keysToBytesArray(keys));
            HashSet<Object> result = new HashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set sdiff(Object ... keys) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.sdiff(this.keysToBytesArray(keys));
            HashSet<Object> result = new HashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            HashSet<Object> hashSet = result;
            return hashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(Object key, double score, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zadd(this.keyToBytes(key), score, this.valueToBytes(member));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zadd(Object key, Map<Object, Double> scoreMembers) {
        Jedis jedis = this.getJedis();
        try {
            HashMap<byte[], Double> para = new HashMap<byte[], Double>();
            for (Map.Entry<Object, Double> e : scoreMembers.entrySet()) {
                para.put(this.valueToBytes(e.getKey()), e.getValue());
            }
            Long l = jedis.zadd(this.keyToBytes(key), para);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zcard(Object key) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zcard(this.keyToBytes(key));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zcount(Object key, double min, double max) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zcount(this.keyToBytes(key), min, max);
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double zincrby(Object key, double score, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Double d = jedis.zincrby(this.keyToBytes(key), score, this.valueToBytes(member));
            return d;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set zrange(Object key, long start, long end) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.zrange(this.keyToBytes(key), start, end);
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            LinkedHashSet<Object> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set zrevrange(Object key, long start, long end) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.zrevrange(this.keyToBytes(key), start, end);
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            LinkedHashSet<Object> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set zrangeByScore(Object key, double min, double max) {
        Jedis jedis = this.getJedis();
        try {
            Set data = jedis.zrangeByScore(this.keyToBytes(key), min, max);
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            this.valueSetFromBytesSet(data, result);
            LinkedHashSet<Object> linkedHashSet = result;
            return linkedHashSet;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrank(Object key, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zrank(this.keyToBytes(key), this.valueToBytes(member));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrevrank(Object key, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zrevrank(this.keyToBytes(key), this.valueToBytes(member));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long zrem(Object key, Object ... members) {
        Jedis jedis = this.getJedis();
        try {
            Long l = jedis.zrem(this.keyToBytes(key), this.valuesToBytesArray(members));
            return l;
        }
        finally {
            this.close(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double zscore(Object key, Object member) {
        Jedis jedis = this.getJedis();
        try {
            Double d = jedis.zscore(this.keyToBytes(key), this.valueToBytes(member));
            return d;
        }
        finally {
            this.close(jedis);
        }
    }

    private byte[] keyToBytes(Object key) {
        String keyStr = this.keyNamingPolicy.getKeyName(key);
        return this.serializer.keyToBytes(keyStr);
    }

    private String keyFromBytes(byte[] bytes) {
        return this.serializer.keyFromBytes(bytes);
    }

    private byte[][] keysToBytesArray(Object ... keys) {
        byte[][] result = new byte[keys.length][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.keyToBytes(keys[i]);
        }
        return result;
    }

    private Set<String> keySetFromBytesSet(Set<byte[]> data) {
        HashSet<String> result = new HashSet<String>();
        for (byte[] keyBytes : data) {
            result.add(this.keyFromBytes(keyBytes));
        }
        return result;
    }

    private byte[] valueToBytes(Object object) {
        return this.serializer.valueToBytes(object);
    }

    private Object valueFromBytes(byte[] bytes) {
        return this.serializer.valueFromBytes(bytes);
    }

    private byte[][] valuesToBytesArray(Object ... objectArray) {
        byte[][] data = new byte[objectArray.length][];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.valueToBytes(objectArray[i]);
        }
        return data;
    }

    private void valueSetFromBytesSet(Set<byte[]> data, Set<Object> result) {
        for (byte[] d : data) {
            result.add(this.valueFromBytes(d));
        }
    }

    private List valueListFromBytesList(List<byte[]> data) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (byte[] d : data) {
            result.add(this.valueFromBytes(d));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public ISerializer getSerializer() {
        return this.serializer;
    }

    public IKeyNamingPolicy getKeyNamingPolicy() {
        return this.keyNamingPolicy;
    }

    public Jedis getJedis() {
        Jedis jedis = this.threadLocalJedis.get();
        return jedis != null ? jedis : this.jedisPool.getResource();
    }

    public void close(Jedis jedis) {
        if (this.threadLocalJedis.get() == null && jedis != null) {
            jedis.close();
        }
    }

    public Jedis getThreadLocalJedis() {
        return this.threadLocalJedis.get();
    }

    public void setThreadLocalJedis(Jedis jedis) {
        this.threadLocalJedis.set(jedis);
    }

    public void removeThreadLocalJedis() {
        this.threadLocalJedis.remove();
    }
}

