/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord.tx;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.NestedTransactionHelpException;
import com.jfinal.plugin.activerecord.tx.TxConfig;
import java.sql.Connection;
import java.sql.SQLException;

public class Tx
implements Interceptor {
    public static Config getConfigWithTxConfig(Invocation inv) {
        TxConfig txConfig = inv.getMethod().getAnnotation(TxConfig.class);
        if (txConfig == null) {
            txConfig = inv.getTarget().getClass().getAnnotation(TxConfig.class);
        }
        if (txConfig != null) {
            Config config = DbKit.getConfig(txConfig.value());
            if (config == null) {
                throw new RuntimeException("Config not found with TxConfig: " + txConfig.value());
            }
            return config;
        }
        return null;
    }

    protected int getTransactionLevel(Config config) {
        return config.getTransactionLevel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void intercept(Invocation inv) {
        Connection conn;
        Config config = Tx.getConfigWithTxConfig(inv);
        if (config == null) {
            config = DbKit.getConfig();
        }
        if ((conn = config.getThreadLocalConnection()) != null) {
            try {
                if (conn.getTransactionIsolation() < this.getTransactionLevel(config)) {
                    conn.setTransactionIsolation(this.getTransactionLevel(config));
                }
                inv.invoke();
                return;
            }
            catch (SQLException e) {
                throw new ActiveRecordException(e);
            }
        }
        Boolean autoCommit = null;
        try {
            conn = config.getConnection();
            autoCommit = conn.getAutoCommit();
            config.setThreadLocalConnection(conn);
            conn.setTransactionIsolation(this.getTransactionLevel(config));
            conn.setAutoCommit(false);
            inv.invoke();
            conn.commit();
            return;
        }
        catch (NestedTransactionHelpException e) {
            if (conn == null) return;
            try {
                conn.rollback();
                return;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return;
            }
        }
        catch (Throwable t) {
            RuntimeException runtimeException;
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (t instanceof RuntimeException) {
                runtimeException = (RuntimeException)t;
                throw runtimeException;
            }
            runtimeException = new ActiveRecordException(t);
            throw runtimeException;
        }
        finally {
            try {
                if (conn != null) {
                    if (autoCommit != null) {
                        conn.setAutoCommit(autoCommit);
                    }
                    conn.close();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                config.removeThreadLocalConnection();
            }
        }
    }
}

