/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.plugin.activerecord.ActiveRecordException;
import com.jfinal.plugin.activerecord.Config;
import com.jfinal.plugin.activerecord.DbKit;
import com.jfinal.plugin.activerecord.Table;
import com.jfinal.plugin.activerecord.TableMapping;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class TableBuilder {
    private static final Map<String, Class<?>> strToType = new HashMap<String, Class<?>>(){
        private static final long serialVersionUID = -8651755311062618532L;
        {
            this.put("java.lang.String", String.class);
            this.put("java.lang.Integer", Integer.class);
            this.put("java.lang.Long", Long.class);
            this.put("java.sql.Date", Date.class);
            this.put("java.lang.Double", Double.class);
            this.put("java.lang.Float", Float.class);
            this.put("java.lang.Boolean", Boolean.class);
            this.put("java.sql.Time", Time.class);
            this.put("java.sql.Timestamp", Timestamp.class);
            this.put("java.math.BigDecimal", BigDecimal.class);
            this.put("[B", byte[].class);
        }
    };

    TableBuilder() {
    }

    static void build(List<Table> tableList, Config config) {
        Table temp = null;
        Connection conn = null;
        try {
            conn = config.dataSource.getConnection();
            TableMapping tableMapping = TableMapping.me();
            Iterator<Table> i$ = tableList.iterator();
            while (i$.hasNext()) {
                Table table;
                temp = table = i$.next();
                TableBuilder.doBuild(table, conn, config);
                tableMapping.putTable(table);
                DbKit.addModelToConfigMapping(table.getModelClass(), config);
            }
        }
        catch (Exception e) {
            if (temp != null) {
                System.err.println("Can not create Table object, maybe the table " + temp.getName() + " is not exists.");
            }
            throw new ActiveRecordException(e);
        }
        finally {
            config.close(conn);
        }
    }

    private static void doBuild(Table table, Connection conn, Config config) throws SQLException {
        table.setColumnTypeMap(config.containerFactory.getAttrsMap());
        if (table.getPrimaryKey() == null) {
            table.setPrimaryKey(config.dialect.getDefaultPrimaryKey());
        }
        String sql = config.dialect.forTableBuilderDoBuild(table.getName());
        Statement stm = conn.createStatement();
        ResultSet rs = stm.executeQuery(sql);
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
            String colName = rsmd.getColumnName(i);
            String colClassName = rsmd.getColumnClassName(i);
            Class<?> clazz = strToType.get(colClassName);
            if (clazz != null) {
                table.setColumnType(colName, clazz);
                continue;
            }
            int type = rsmd.getColumnType(i);
            if (type == 2004) {
                table.setColumnType(colName, byte[].class);
                continue;
            }
            if (type == 2005 || type == 2011) {
                table.setColumnType(colName, String.class);
                continue;
            }
            table.setColumnType(colName, String.class);
        }
        rs.close();
        stm.close();
    }
}

