/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.plugin.activerecord;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.plugin.activerecord.DbKit;
import java.sql.Connection;

public class OneConnectionPerThread
implements Interceptor {
    @Override
    public void intercept(Invocation inv) {
        Connection conn = DbKit.config.getThreadLocalConnection();
        if (conn != null) {
            inv.invoke();
            return;
        }
        try {
            conn = DbKit.config.getConnection();
            DbKit.config.setThreadLocalConnection(conn);
            inv.invoke();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DbKit.config.removeThreadLocalConnection();
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

