/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.kit;

import com.jfinal.kit.StrKit;
import com.jfinal.plugin.activerecord.CPI;
import com.jfinal.plugin.activerecord.Model;
import com.jfinal.plugin.activerecord.Record;
import java.lang.reflect.Method;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JsonKit {
    private static int convertDepth = 15;
    private static String timestampPattern = "yyyy-MM-dd HH:mm:ss";
    private static String datePattern = "yyyy-MM-dd";

    public static void setConvertDepth(int convertDepth) {
        if (convertDepth < 2) {
            throw new IllegalArgumentException("convert depth can not less than 2.");
        }
        JsonKit.convertDepth = convertDepth;
    }

    public static void setTimestampPattern(String timestampPattern) {
        if (timestampPattern == null || "".equals(timestampPattern.trim())) {
            throw new IllegalArgumentException("timestampPattern can not be blank.");
        }
        JsonKit.timestampPattern = timestampPattern;
    }

    public static void setDatePattern(String datePattern) {
        if (datePattern == null || "".equals(datePattern.trim())) {
            throw new IllegalArgumentException("datePattern can not be blank.");
        }
        JsonKit.datePattern = datePattern;
    }

    private static String mapToJson(Map map, int depth) {
        if (map == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        Iterator iter = map.entrySet().iterator();
        sb.append('{');
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Map.Entry entry = iter.next();
            JsonKit.toKeyValue(String.valueOf(entry.getKey()), entry.getValue(), sb, depth);
        }
        sb.append('}');
        return sb.toString();
    }

    private static String toKeyValue(String key, Object value, StringBuilder sb, int depth) {
        sb.append('\"');
        if (key == null) {
            sb.append("null");
        } else {
            JsonKit.escape(key, sb);
        }
        sb.append('\"').append(':');
        sb.append(JsonKit.toJson(value, depth));
        return sb.toString();
    }

    private static String listToJson(List list, int depth) {
        if (list == null) {
            return "null";
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        Iterator iter = list.iterator();
        sb.append('[');
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Object value = iter.next();
            if (value == null) {
                sb.append("null");
                continue;
            }
            sb.append(JsonKit.toJson(value, depth));
        }
        sb.append(']');
        return sb.toString();
    }

    private static String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        JsonKit.escape(s, sb);
        return sb.toString();
    }

    private static void escape(String s, StringBuilder sb) {
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String str = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int k = 0; k < 4 - str.length(); ++k) {
                            sb.append('0');
                        }
                        sb.append(str.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
    }

    public static String toJson(Object value) {
        return JsonKit.toJson(value, convertDepth);
    }

    public static String toJson(Object value, int depth) {
        if (value == null || depth-- < 0) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + JsonKit.escape((String)value) + "\"";
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Date) {
            if (value instanceof Timestamp) {
                return "\"" + new SimpleDateFormat(timestampPattern).format(value) + "\"";
            }
            if (value instanceof Time) {
                return "\"" + value.toString() + "\"";
            }
            return "\"" + new SimpleDateFormat(datePattern).format(value) + "\"";
        }
        if (value instanceof Map) {
            return JsonKit.mapToJson((Map)value, depth);
        }
        if (value instanceof List) {
            return JsonKit.listToJson((List)value, depth);
        }
        String result = JsonKit.otherToJson(value, depth);
        if (result != null) {
            return result;
        }
        return "\"" + JsonKit.escape(value.toString()) + "\"";
    }

    private static String otherToJson(Object value, int depth) {
        if (value instanceof Character) {
            return "\"" + JsonKit.escape(value.toString()) + "\"";
        }
        if (value instanceof Model) {
            Map<String, Object> map = CPI.getAttrs((Model)value);
            return JsonKit.mapToJson(map, depth);
        }
        if (value instanceof Record) {
            Map<String, Object> map = ((Record)value).getColumns();
            return JsonKit.mapToJson(map, depth);
        }
        if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            ArrayList<Object> list = new ArrayList<Object>(arr.length);
            for (int i = 0; i < arr.length; ++i) {
                list.add(arr[i]);
            }
            return JsonKit.listToJson(list, depth);
        }
        if (value instanceof Enum) {
            return "\"" + ((Enum)value).toString() + "\"";
        }
        return JsonKit.beanToJson(value, depth);
    }

    private static String beanToJson(Object model, int depth) {
        Method[] methods;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Method m : methods = model.getClass().getMethods()) {
            String methodName = m.getName();
            int indexOfGet = methodName.indexOf("get");
            if (indexOfGet == 0 && methodName.length() > 3) {
                Class<?>[] types;
                String attrName = methodName.substring(3);
                if (attrName.equals("Class") || (types = m.getParameterTypes()).length != 0) continue;
                try {
                    Object value = m.invoke(model, new Object[0]);
                    map.put(StrKit.firstCharToLowerCase(attrName), value);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            int indexOfIs = methodName.indexOf("is");
            if (indexOfIs != 0 || methodName.length() <= 2) continue;
            String attrName = methodName.substring(2);
            Class<?>[] types = m.getParameterTypes();
            if (types.length != 0) continue;
            try {
                Object value = m.invoke(model, new Object[0]);
                map.put(StrKit.firstCharToLowerCase(attrName), value);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return JsonKit.mapToJson(map, depth);
    }
}

