/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.i18n;

import com.jfinal.kit.StrKit;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class Res {
    private final ResourceBundle resourceBundle;

    public Res(String baseName, String locale) {
        if (StrKit.isBlank(baseName)) {
            throw new IllegalArgumentException("baseName can not be blank");
        }
        if (StrKit.isBlank(locale)) {
            throw new IllegalArgumentException("locale can not be blank, the format like this: zh_CN or en_US");
        }
        this.resourceBundle = ResourceBundle.getBundle(baseName, this.parseLocale(locale));
    }

    private Locale parseLocale(String locale) {
        String[] array = locale.split("_");
        if (array.length == 1) {
            return new Locale(array[0]);
        }
        return new Locale(array[0], array[1]);
    }

    public String get(String key) {
        return this.resourceBundle.getString(key);
    }

    public String format(String key, Object ... arguments) {
        return MessageFormat.format(this.resourceBundle.getString(key), arguments);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

