/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.aop.Interceptor;
import com.jfinal.core.Action;
import com.jfinal.core.Controller;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

final class ActionReporter {
    private static final ThreadLocal<SimpleDateFormat> sdf = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };

    ActionReporter() {
    }

    static final boolean reportCommonRequest(Controller controller, Action action) {
        String content_type = controller.getRequest().getContentType();
        if (content_type == null || content_type.toLowerCase().indexOf("multipart") == -1) {
            ActionReporter.doReport(controller, action);
            return false;
        }
        return true;
    }

    static final void reportMultipartRequest(Controller controller, Action action) {
        ActionReporter.doReport(controller, action);
    }

    private static final void doReport(Controller controller, Action action) {
        HttpServletRequest request;
        Enumeration e;
        Interceptor[] inters;
        StringBuilder sb = new StringBuilder("\nJFinal action report -------- ").append(sdf.get().format(new Date())).append(" ------------------------------\n");
        Class<? extends Controller> cc = action.getControllerClass();
        sb.append("Controller  : ").append(cc.getName()).append(".(").append(cc.getSimpleName()).append(".java:1)");
        sb.append("\nMethod      : ").append(action.getMethodName()).append("\n");
        String urlParas = controller.getPara();
        if (urlParas != null) {
            sb.append("UrlPara     : ").append(urlParas).append("\n");
        }
        if ((inters = action.getInterceptors()).length > 0) {
            sb.append("Interceptor : ");
            for (int i = 0; i < inters.length; ++i) {
                if (i > 0) {
                    sb.append("\n              ");
                }
                Interceptor inter = inters[i];
                Class<?> ic = inter.getClass();
                sb.append(ic.getName()).append(".(").append(ic.getSimpleName()).append(".java:1)");
            }
            sb.append("\n");
        }
        if ((e = (request = controller.getRequest()).getParameterNames()).hasMoreElements()) {
            sb.append("Parameter   : ");
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String[] values = request.getParameterValues(name);
                if (values.length == 1) {
                    sb.append(name).append("=").append(values[0]);
                } else {
                    sb.append(name).append("[]={");
                    for (int i = 0; i < values.length; ++i) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        sb.append(values[i]);
                    }
                    sb.append("}");
                }
                sb.append("  ");
            }
            sb.append("\n");
        }
        sb.append("--------------------------------------------------------------------------------\n");
        System.out.print(sb.toString());
    }
}

