/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.core;

import com.jfinal.aop.Before;
import com.jfinal.aop.Clear;
import com.jfinal.aop.Interceptor;
import com.jfinal.core.Controller;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class ActionInterceptorBuilder {
    public static final Interceptor[] NULL_INTERS = new Interceptor[0];
    private Map<Class<? extends Interceptor>, Interceptor> intersMap = new HashMap<Class<? extends Interceptor>, Interceptor>();

    ActionInterceptorBuilder() {
    }

    void addToInterceptorsMap(Interceptor[] globalInters) {
        for (Interceptor inter : globalInters) {
            this.intersMap.put(inter.getClass(), inter);
        }
    }

    Interceptor[] buildControllerInterceptors(Class<? extends Controller> controllerClass) {
        return this.createInterceptors(controllerClass.getAnnotation(Before.class));
    }

    Interceptor[] buildMethodInterceptors(Method method) {
        return this.createInterceptors(method.getAnnotation(Before.class));
    }

    Interceptor[] buildActionInterceptors(Interceptor[] globalInters, Interceptor[] controllerInters, Interceptor[] methodInters, Method method) {
        Clear clear = method.getAnnotation(Clear.class);
        if (clear == null) {
            Interceptor[] result = new Interceptor[globalInters.length + controllerInters.length + methodInters.length];
            int index = 0;
            for (Interceptor inter : globalInters) {
                result[index++] = inter;
            }
            for (Interceptor inter : controllerInters) {
                result[index++] = inter;
            }
            for (Interceptor inter : methodInters) {
                result[index++] = inter;
            }
            return result;
        }
        Class<? extends Interceptor>[] clearInters = clear.value();
        if (clearInters.length == 0) {
            return methodInters;
        }
        Interceptor[] temp = new Interceptor[globalInters.length + controllerInters.length];
        int index = 0;
        for (Interceptor inter : globalInters) {
            temp[index++] = inter;
        }
        for (Interceptor inter : controllerInters) {
            temp[index++] = inter;
        }
        int removeCount = 0;
        block5: for (int i = 0; i < temp.length; ++i) {
            Class<? extends Interceptor>[] arr$ = clearInters;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Class<? extends Interceptor> ci = arr$[i$];
                if (temp[i].getClass() != ci) continue;
                temp[i] = null;
                ++removeCount;
                continue block5;
            }
        }
        Interceptor[] result = new Interceptor[temp.length + methodInters.length - removeCount];
        index = 0;
        for (Interceptor inter : temp) {
            if (inter == null) continue;
            result[index++] = inter;
        }
        for (Interceptor inter : methodInters) {
            result[index++] = inter;
        }
        return result;
    }

    private Interceptor[] createInterceptors(Before beforeAnnotation) {
        if (beforeAnnotation == null) {
            return NULL_INTERS;
        }
        Class<? extends Interceptor>[] interceptorClasses = beforeAnnotation.value();
        if (interceptorClasses.length == 0) {
            return NULL_INTERS;
        }
        Interceptor[] result = new Interceptor[interceptorClasses.length];
        try {
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.intersMap.get(interceptorClasses[i]);
                if (result[i] != null) continue;
                result[i] = interceptorClasses[i].newInstance();
                this.intersMap.put(interceptorClasses[i], result[i]);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }
}

