/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.config;

import com.jfinal.config.Constants;
import com.jfinal.config.Handlers;
import com.jfinal.config.Interceptors;
import com.jfinal.config.Plugins;
import com.jfinal.config.Routes;
import com.jfinal.kit.Prop;
import com.jfinal.kit.PropKit;
import java.io.File;
import java.util.Properties;

public abstract class JFinalConfig {
    protected Prop prop = null;

    public abstract void configConstant(Constants var1);

    public abstract void configRoute(Routes var1);

    public abstract void configPlugin(Plugins var1);

    public abstract void configInterceptor(Interceptors var1);

    public abstract void configHandler(Handlers var1);

    public void afterJFinalStart() {
    }

    public void beforeJFinalStop() {
    }

    public Properties loadPropertyFile(String fileName) {
        return this.loadPropertyFile(fileName, "UTF-8");
    }

    public Properties loadPropertyFile(String fileName, String encoding) {
        this.prop = PropKit.use(fileName, encoding);
        return this.prop.getProperties();
    }

    public Properties loadPropertyFile(File file) {
        return this.loadPropertyFile(file, "UTF-8");
    }

    public Properties loadPropertyFile(File file, String encoding) {
        this.prop = PropKit.use(file, encoding);
        return this.prop.getProperties();
    }

    public void unloadPropertyFile(String fileName) {
        Prop uselessProp = PropKit.useless(fileName);
        if (this.prop == uselessProp) {
            this.prop = null;
        }
    }

    public void unloadAllPropertyFiles() {
        PropKit.clear();
        this.prop = null;
    }

    private Prop getProp() {
        if (this.prop == null) {
            throw new IllegalStateException("Load propties file by invoking loadPropertyFile(String fileName) method first.");
        }
        return this.prop;
    }

    public String getProperty(String key) {
        return this.getProp().get(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.getProp().get(key, defaultValue);
    }

    public Integer getPropertyToInt(String key) {
        return this.getProp().getInt(key);
    }

    public Integer getPropertyToInt(String key, Integer defaultValue) {
        return this.getProp().getInt(key, defaultValue);
    }

    public Long getPropertyToLong(String key) {
        return this.getProp().getLong(key);
    }

    public Long getPropertyToLong(String key, Long defaultValue) {
        return this.getProp().getLong(key, defaultValue);
    }

    public Boolean getPropertyToBoolean(String key) {
        return this.getProp().getBoolean(key);
    }

    public Boolean getPropertyToBoolean(String key, Boolean defaultValue) {
        return this.getProp().getBoolean(key, defaultValue);
    }
}

