/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.aop;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.InterceptorBuilder;
import com.jfinal.aop.Invocation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

class Callback
implements MethodInterceptor {
    private Object injectTarget = null;
    private final Interceptor[] injectInters;
    private static final Set<String> excludedMethodName = Callback.buildExcludedMethodName();

    public Callback() {
        this.injectInters = InterceptorBuilder.NULL_INTERS;
    }

    public Callback(Interceptor ... injectInters) {
        if (injectInters == null) {
            throw new IllegalArgumentException("injectInters can not be null.");
        }
        this.injectInters = injectInters;
    }

    public Callback(Object injectTarget, Interceptor ... injectInters) {
        if (injectTarget == null) {
            throw new IllegalArgumentException("injectTarget can not be null.");
        }
        if (injectInters == null) {
            throw new IllegalArgumentException("injectInters can not be null.");
        }
        this.injectTarget = injectTarget;
        this.injectInters = injectInters;
    }

    public Object intercept(Object target, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        if (excludedMethodName.contains(method.getName())) {
            if (method.getName().equals("finalize")) {
                return methodProxy.invokeSuper(target, args);
            }
            return this.injectTarget != null ? methodProxy.invoke(this.injectTarget, args) : methodProxy.invokeSuper(target, args);
        }
        if (this.injectTarget != null) {
            target = this.injectTarget;
            Interceptor[] finalInters = InterceptorBuilder.build(this.injectInters, target.getClass(), method);
            Invocation invocation = new Invocation(target, method, args, methodProxy, finalInters);
            invocation.useInjectTarget = true;
            invocation.invoke();
            return invocation.getReturnValue();
        }
        Interceptor[] finalInters = InterceptorBuilder.build(this.injectInters, target.getClass(), method);
        Invocation invocation = new Invocation(target, method, args, methodProxy, finalInters);
        invocation.useInjectTarget = false;
        invocation.invoke();
        return invocation.getReturnValue();
    }

    private static final Set<String> buildExcludedMethodName() {
        Method[] methods;
        HashSet<String> excludedMethodName = new HashSet<String>();
        for (Method m : methods = Object.class.getDeclaredMethods()) {
            excludedMethodName.add(m.getName());
        }
        return excludedMethodName;
    }
}

