/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Relationship;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.impl.CustomToStringStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipImpl
implements Relationship {
    private static final int ONE_TO_ONE_FLAG = 1;
    private static final int NO_REFERENTIAL_INTEGRITY_FLAG = 2;
    private static final int CASCADE_UPDATES_FLAG = 256;
    private static final int CASCADE_DELETES_FLAG = 4096;
    private static final int LEFT_OUTER_JOIN_FLAG = 0x1000000;
    private static final int RIGHT_OUTER_JOIN_FLAG = 0x2000000;
    private final String _name;
    private final Table _fromTable;
    private final Table _toTable;
    private final List<Column> _toColumns;
    private final List<Column> _fromColumns;
    private final int _flags;

    public RelationshipImpl(String name, Table fromTable, Table toTable, int flags, int numCols) {
        this._name = name;
        this._fromTable = fromTable;
        this._fromColumns = new ArrayList<Column>(Collections.nCopies(numCols, null));
        this._toTable = toTable;
        this._toColumns = new ArrayList<Column>(Collections.nCopies(numCols, null));
        this._flags = flags;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Table getFromTable() {
        return this._fromTable;
    }

    @Override
    public List<Column> getFromColumns() {
        return this._fromColumns;
    }

    @Override
    public Table getToTable() {
        return this._toTable;
    }

    @Override
    public List<Column> getToColumns() {
        return this._toColumns;
    }

    public int getFlags() {
        return this._flags;
    }

    @Override
    public boolean isOneToOne() {
        return this.hasFlag(1);
    }

    @Override
    public boolean hasReferentialIntegrity() {
        return !this.hasFlag(2);
    }

    @Override
    public boolean cascadeUpdates() {
        return this.hasFlag(256);
    }

    @Override
    public boolean cascadeDeletes() {
        return this.hasFlag(4096);
    }

    @Override
    public boolean isLeftOuterJoin() {
        return this.hasFlag(0x1000000);
    }

    @Override
    public boolean isRightOuterJoin() {
        return this.hasFlag(0x2000000);
    }

    private boolean hasFlag(int flagMask) {
        return (this.getFlags() & flagMask) != 0;
    }

    public String toString() {
        return CustomToStringStyle.builder(this).append("name", (Object)this._name).append("fromTable", (Object)this._fromTable.getName()).append("fromColumns", this._fromColumns).append("toTable", (Object)this._toTable.getName()).append("toColumns", this._toColumns).append("flags", (Object)Integer.toHexString(this._flags)).toString();
    }
}

