/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.PropertyMaps;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMapImpl
implements PropertyMap {
    private static final Map<String, DataType> DEFAULT_TYPES = new HashMap<String, DataType>();
    private final String _mapName;
    private final short _mapType;
    private final Map<String, PropertyMap.Property> _props = new LinkedHashMap<String, PropertyMap.Property>();
    private final PropertyMaps _owner;

    public PropertyMapImpl(String name, short type, PropertyMaps owner) {
        this._mapName = name;
        this._mapType = type;
        this._owner = owner;
    }

    @Override
    public String getName() {
        return this._mapName;
    }

    public short getType() {
        return this._mapType;
    }

    public PropertyMaps getOwner() {
        return this._owner;
    }

    @Override
    public int getSize() {
        return this._props.size();
    }

    @Override
    public boolean isEmpty() {
        return this._props.isEmpty();
    }

    @Override
    public PropertyMap.Property get(String name) {
        return this._props.get(DatabaseImpl.toLookupName(name));
    }

    @Override
    public Object getValue(String name) {
        return this.getValue(name, null);
    }

    @Override
    public Object getValue(String name, Object defaultValue) {
        PropertyMap.Property prop = this.get(name);
        Object value = defaultValue;
        if (prop != null && prop.getValue() != null) {
            value = prop.getValue();
        }
        return value;
    }

    @Override
    public PropertyImpl put(String name, Object value) {
        return this.put(name, null, (byte)0, value);
    }

    @Override
    public PropertyImpl put(String name, DataType type, Object value) {
        return this.put(name, type, (byte)0, value);
    }

    @Override
    public void putAll(Iterable<? extends PropertyMap.Property> props) {
        if (props == null) {
            return;
        }
        for (PropertyMap.Property property : props) {
            byte flag = 0;
            if (property instanceof PropertyImpl) {
                flag = ((PropertyImpl)property).getFlag();
            }
            this.put(property.getName(), property.getType(), flag, property.getValue());
        }
    }

    public PropertyImpl put(String name, DataType type, byte flag, Object value) {
        PropertyImpl prop = (PropertyImpl)PropertyMapImpl.createProperty(name, type, flag, value);
        this._props.put(DatabaseImpl.toLookupName(name), prop);
        return prop;
    }

    @Override
    public PropertyImpl remove(String name) {
        return (PropertyImpl)this._props.remove(DatabaseImpl.toLookupName(name));
    }

    @Override
    public Iterator<PropertyMap.Property> iterator() {
        return this._props.values().iterator();
    }

    @Override
    public void save() throws IOException {
        this.getOwner().save();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("".equals(this.getName()) ? "<DEFAULT>" : this.getName()).append(" {");
        Iterator<PropertyMap.Property> iter = this.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public static PropertyMap.Property createProperty(String name, DataType type, Object value) {
        return PropertyMapImpl.createProperty(name, type, (byte)0, value);
    }

    public static PropertyMap.Property createProperty(String name, DataType type, byte flag, Object value) {
        if (type == null && (type = DEFAULT_TYPES.get(name)) == null) {
            if (value instanceof String) {
                type = DataType.TEXT;
            } else if (value instanceof Boolean) {
                type = DataType.BOOLEAN;
            } else if (value instanceof Byte) {
                type = DataType.BYTE;
            } else if (value instanceof Short) {
                type = DataType.INT;
            } else if (value instanceof Integer) {
                type = DataType.LONG;
            } else if (value instanceof Float) {
                type = DataType.FLOAT;
            } else if (value instanceof Double) {
                type = DataType.DOUBLE;
            } else if (value instanceof Date) {
                type = DataType.SHORT_DATE_TIME;
            } else if (value instanceof byte[]) {
                type = DataType.OLE;
            } else {
                throw new IllegalArgumentException("Could not determine type for property " + name + " with value " + value);
            }
        }
        return new PropertyImpl(name, type, flag, value);
    }

    static {
        DEFAULT_TYPES.put("AccessVersion", DataType.TEXT);
        DEFAULT_TYPES.put("Title", DataType.TEXT);
        DEFAULT_TYPES.put("Author", DataType.TEXT);
        DEFAULT_TYPES.put("Company", DataType.TEXT);
        DEFAULT_TYPES.put("DefaultValue", DataType.MEMO);
        DEFAULT_TYPES.put("Required", DataType.BOOLEAN);
        DEFAULT_TYPES.put("AllowZeroLength", DataType.BOOLEAN);
        DEFAULT_TYPES.put("DecimalPlaces", DataType.BYTE);
        DEFAULT_TYPES.put("Format", DataType.TEXT);
        DEFAULT_TYPES.put("InputMask", DataType.TEXT);
        DEFAULT_TYPES.put("Caption", DataType.MEMO);
        DEFAULT_TYPES.put("ValidationRule", DataType.TEXT);
        DEFAULT_TYPES.put("ValidationText", DataType.TEXT);
        DEFAULT_TYPES.put("GUID", DataType.BINARY);
        DEFAULT_TYPES.put("Description", DataType.MEMO);
        DEFAULT_TYPES.put("ResultType", DataType.BYTE);
        DEFAULT_TYPES.put("Expression", DataType.MEMO);
    }

    static final class PropertyImpl
    implements PropertyMap.Property {
        private final String _name;
        private final DataType _type;
        private final byte _flag;
        private Object _value;

        private PropertyImpl(String name, DataType type, byte flag, Object value) {
            this._name = name;
            this._type = type;
            this._flag = flag;
            this._value = value;
        }

        public String getName() {
            return this._name;
        }

        public DataType getType() {
            return this._type;
        }

        public Object getValue() {
            return this._value;
        }

        public void setValue(Object newValue) {
            this._value = newValue;
        }

        public byte getFlag() {
            return this._flag;
        }

        public String toString() {
            Object val = this.getValue();
            if (val instanceof byte[]) {
                val = ByteUtil.toHexString((byte[])val);
            }
            return this.getName() + "[" + (Object)((Object)this.getType()) + ":" + this._flag + "]=" + val;
        }
    }
}

