/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.DbException;
import org.h2.util.MathUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueDecimal
extends Value {
    public static final Object ZERO = new ValueDecimal(BigDecimal.ZERO);
    public static final Object ONE = new ValueDecimal(BigDecimal.ONE);
    static final int DEFAULT_PRECISION = 65535;
    static final int DEFAULT_SCALE = Short.MAX_VALUE;
    static final int DEFAULT_DISPLAY_SIZE = 65535;
    private static final int DIVIDE_SCALE_ADD = 25;
    private final BigDecimal value;
    private String valueString;
    private int precision;

    private ValueDecimal(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException();
        }
        if (!SysProperties.ALLOW_BIG_DECIMAL_EXTENSIONS && !bigDecimal.getClass().equals(BigDecimal.class)) {
            throw DbException.get(90125, BigDecimal.class.getName(), bigDecimal.getClass().getName());
        }
        this.value = bigDecimal;
    }

    public Value add(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return ValueDecimal.get(this.value.add(valueDecimal.value));
    }

    public Value subtract(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return ValueDecimal.get(this.value.subtract(valueDecimal.value));
    }

    public Value negate() {
        return ValueDecimal.get(this.value.negate());
    }

    public Value multiply(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return ValueDecimal.get(this.value.multiply(valueDecimal.value));
    }

    public Value divide(Value value) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        if (valueDecimal.value.signum() == 0) {
            throw DbException.get(22012, this.getSQL());
        }
        BigDecimal bigDecimal = this.value.divide(valueDecimal.value, this.value.scale() + 25, 5);
        if (bigDecimal.signum() == 0) {
            bigDecimal = BigDecimal.ZERO;
        } else if (bigDecimal.scale() > 0 && !bigDecimal.unscaledValue().testBit(0)) {
            int n;
            String string = bigDecimal.toString();
            for (n = string.length() - 1; n >= 0 && string.charAt(n) == '0'; --n) {
            }
            if (n < string.length() - 1) {
                string = string.substring(0, n + 1);
                bigDecimal = new BigDecimal(string);
            }
        }
        return ValueDecimal.get(bigDecimal);
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 6;
    }

    protected int compareSecure(Value value, CompareMode compareMode) {
        ValueDecimal valueDecimal = (ValueDecimal)value;
        return this.value.compareTo(valueDecimal.value);
    }

    public int getSignum() {
        return this.value.signum();
    }

    public BigDecimal getBigDecimal() {
        return this.value;
    }

    public String getString() {
        if (this.valueString == null) {
            this.valueString = this.value.toString();
        }
        return this.valueString;
    }

    public long getPrecision() {
        if (this.precision == 0) {
            this.precision = this.value.unscaledValue().abs().toString().length();
        }
        return this.precision;
    }

    public boolean checkPrecision(long l) {
        if (l == 65535L) {
            return true;
        }
        return this.getPrecision() <= l;
    }

    public int getScale() {
        return this.value.scale();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public Object getObject() {
        return this.value;
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setBigDecimal(n, this.value);
    }

    public Value convertScale(boolean bl, int n) {
        if (this.value.scale() == n) {
            return this;
        }
        if ((bl || n >= Short.MAX_VALUE) && this.value.scale() < n) {
            return this;
        }
        BigDecimal bigDecimal = MathUtils.setScale(this.value, n);
        return ValueDecimal.get(bigDecimal);
    }

    public Value convertPrecision(long l) {
        if (this.getPrecision() <= l) {
            return this;
        }
        throw DbException.get(90039, "" + l);
    }

    public static ValueDecimal get(BigDecimal bigDecimal) {
        if (BigDecimal.ZERO.equals(bigDecimal)) {
            return (ValueDecimal)ZERO;
        }
        if (BigDecimal.ONE.equals(bigDecimal)) {
            return (ValueDecimal)ONE;
        }
        return (ValueDecimal)Value.cache(new ValueDecimal(bigDecimal));
    }

    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision() + 2L);
    }

    public boolean equals(Object object) {
        return object instanceof ValueDecimal && this.value.equals(((ValueDecimal)object).value);
    }

    public int getMemory() {
        return this.getString().length() * 3 + 120;
    }
}

