/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.cmp.JarArchiveComparator;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiClassType;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiHasChangeStatus;
import japicmp.util.ClassHelper;
import japicmp.util.Optional;
import japicmp.util.OptionalHelper;
import java.util.LinkedList;
import java.util.List;
import javassist.CtClass;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

public class JApiSuperclass
implements JApiHasChangeStatus,
JApiCompatibility {
    private final JApiClass jApiClass;
    private final Optional<CtClass> oldSuperclassOptional;
    private final Optional<CtClass> newSuperclassOptional;
    private final JApiChangeStatus changeStatus;
    private final JarArchiveComparator jarArchiveComparator;
    private final List<JApiCompatibilityChange> compatibilityChanges = new LinkedList<JApiCompatibilityChange>();
    private Optional<JApiClass> correspondingJApiClass = Optional.absent();

    public JApiSuperclass(JApiClass jApiClass, Optional<CtClass> oldSuperclassOptional, Optional<CtClass> newSuperclassOptional, JApiChangeStatus changeStatus, JarArchiveComparator jarArchiveComparator) {
        this.jApiClass = jApiClass;
        this.oldSuperclassOptional = oldSuperclassOptional;
        this.newSuperclassOptional = newSuperclassOptional;
        this.changeStatus = changeStatus;
        this.jarArchiveComparator = jarArchiveComparator;
    }

    public Optional<JApiClass> getJApiClass() {
        if (this.oldSuperclassOptional.isPresent() && this.newSuperclassOptional.isPresent()) {
            String newSuperclassName;
            CtClass oldSuperclass = this.oldSuperclassOptional.get();
            CtClass newSuperclass = this.newSuperclassOptional.get();
            String oldSuperclassName = oldSuperclass.getName();
            if (oldSuperclassName.equals(newSuperclassName = newSuperclass.getName())) {
                JApiClassType classType = new JApiClassType(Optional.of(ClassHelper.getType(oldSuperclass)), Optional.of(ClassHelper.getType(newSuperclass)), JApiChangeStatus.UNCHANGED);
                JApiClass jApiClass = new JApiClass(this.jarArchiveComparator, oldSuperclassName, Optional.of(oldSuperclass), Optional.of(newSuperclass), JApiChangeStatus.UNCHANGED, classType);
                return Optional.of(jApiClass);
            }
            return Optional.absent();
        }
        if (this.oldSuperclassOptional.isPresent()) {
            CtClass oldSuperclass = this.oldSuperclassOptional.get();
            String oldSuperclassName = oldSuperclass.getName();
            JApiClassType classType = new JApiClassType(Optional.of(ClassHelper.getType(oldSuperclass)), Optional.absent(), JApiChangeStatus.REMOVED);
            JApiClass jApiClass = new JApiClass(this.jarArchiveComparator, oldSuperclassName, Optional.of(oldSuperclass), Optional.absent(), JApiChangeStatus.REMOVED, classType);
            return Optional.of(jApiClass);
        }
        if (this.newSuperclassOptional.isPresent()) {
            CtClass newSuperclass = this.newSuperclassOptional.get();
            String newSuperclassName = newSuperclass.getName();
            JApiClassType classType = new JApiClassType(Optional.absent(), Optional.of(ClassHelper.getType(newSuperclass)), JApiChangeStatus.NEW);
            JApiClass jApiClass = new JApiClass(this.jarArchiveComparator, newSuperclassName, Optional.absent(), Optional.of(newSuperclass), JApiChangeStatus.NEW, classType);
            return Optional.of(jApiClass);
        }
        return Optional.absent();
    }

    @XmlTransient
    public Optional<CtClass> getOldSuperclass() {
        return this.oldSuperclassOptional;
    }

    @XmlTransient
    public Optional<CtClass> getNewSuperclass() {
        return this.newSuperclassOptional;
    }

    @XmlTransient
    public Optional<String> getOldSuperclassName() {
        return this.oldSuperclassOptional.isPresent() ? Optional.of(this.oldSuperclassOptional.get().getName()) : Optional.absent();
    }

    @XmlTransient
    public Optional<String> getNewSuperclassName() {
        return this.newSuperclassOptional.isPresent() ? Optional.of(this.newSuperclassOptional.get().getName()) : Optional.absent();
    }

    @Override
    @XmlAttribute(name="changeStatus")
    public JApiChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    @XmlAttribute(name="superclassOld")
    public String getSuperclassOld() {
        return OptionalHelper.optionalToString(this.getOldSuperclassName());
    }

    @XmlAttribute(name="superclassNew")
    public String getSuperclassNew() {
        return OptionalHelper.optionalToString(this.getNewSuperclassName());
    }

    @Override
    @XmlAttribute
    public boolean isBinaryCompatible() {
        boolean binaryCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isBinaryCompatible()) continue;
            binaryCompatible = false;
        }
        return binaryCompatible;
    }

    @Override
    @XmlAttribute
    public boolean isSourceCompatible() {
        boolean sourceCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isSourceCompatible()) continue;
            sourceCompatible = false;
        }
        return sourceCompatible;
    }

    @Override
    @XmlElementWrapper(name="compatibilityChanges")
    @XmlElement(name="compatibilityChange")
    public List<JApiCompatibilityChange> getCompatibilityChanges() {
        return this.compatibilityChanges;
    }

    void setJApiClass(JApiClass jApiClass) {
        this.correspondingJApiClass = Optional.of(jApiClass);
    }

    @XmlTransient
    public JApiClass getJApiClassOwning() {
        return this.jApiClass;
    }

    public String toString() {
        String oldSuperClass = "n.a.";
        if (this.oldSuperclassOptional.isPresent()) {
            oldSuperClass = this.oldSuperclassOptional.get().getName();
        }
        String newSuperClass = "n.a.";
        if (this.newSuperclassOptional.isPresent()) {
            newSuperClass = this.newSuperclassOptional.get().getName();
        }
        return "JApiSuperclass [jApiClass=" + this.jApiClass + ", oldSuperclass=" + oldSuperClass + ", newSuperclass=" + newSuperClass + ", changeStatus=" + (Object)((Object)this.changeStatus) + ", compatibilityChanges=" + this.compatibilityChanges + "]";
    }
}

