/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.exception.JApiCmpException;
import japicmp.model.AbstractModifier;
import japicmp.model.AccessModifier;
import japicmp.model.FinalModifier;
import japicmp.model.JApiAnnotation;
import japicmp.model.JApiAttribute;
import japicmp.model.JApiBehavior;
import japicmp.model.JApiCanBeSynthetic;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClassFileFormatVersion;
import japicmp.model.JApiClassType;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiConstructor;
import japicmp.model.JApiField;
import japicmp.model.JApiHasAbstractModifier;
import japicmp.model.JApiHasAccessModifier;
import japicmp.model.JApiHasAnnotations;
import japicmp.model.JApiHasChangeStatus;
import japicmp.model.JApiHasFinalModifier;
import japicmp.model.JApiHasModifiers;
import japicmp.model.JApiHasStaticModifier;
import japicmp.model.JApiImplementedInterface;
import japicmp.model.JApiJavaObjectSerializationCompatibility;
import japicmp.model.JApiMethod;
import japicmp.model.JApiModifier;
import japicmp.model.JApiParameter;
import japicmp.model.JApiSerialVersionUid;
import japicmp.model.JApiSuperclass;
import japicmp.model.JavaObjectSerializationCompatibility;
import japicmp.model.StaticModifier;
import japicmp.model.SyntheticAttribute;
import japicmp.model.SyntheticModifier;
import japicmp.util.AnnotationHelper;
import japicmp.util.MethodDescriptorParser;
import japicmp.util.ModifierHelper;
import japicmp.util.Optional;
import japicmp.util.SignatureParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

public class JApiClass
implements JApiHasModifiers,
JApiHasChangeStatus,
JApiHasAccessModifier,
JApiHasStaticModifier,
JApiHasFinalModifier,
JApiHasAbstractModifier,
JApiCompatibility,
JApiHasAnnotations,
JApiJavaObjectSerializationCompatibility,
JApiCanBeSynthetic {
    private final JarArchiveComparator jarArchiveComparator;
    private final String fullyQualifiedName;
    private final JApiClassType classType;
    private final JarArchiveComparatorOptions options;
    private final Optional<CtClass> oldClass;
    private final Optional<CtClass> newClass;
    private final JApiChangeStatus changeStatus;
    private final JApiSuperclass superclass;
    private final List<JApiImplementedInterface> interfaces = new LinkedList<JApiImplementedInterface>();
    private final List<JApiField> fields = new LinkedList<JApiField>();
    private final List<JApiConstructor> constructors = new LinkedList<JApiConstructor>();
    private final List<JApiMethod> methods = new LinkedList<JApiMethod>();
    private final List<JApiAnnotation> annotations = new LinkedList<JApiAnnotation>();
    private final JApiModifier<AccessModifier> accessModifier;
    private final JApiModifier<FinalModifier> finalModifier;
    private final JApiModifier<StaticModifier> staticModifier;
    private final JApiModifier<AbstractModifier> abstractModifier;
    private final JApiModifier<SyntheticModifier> syntheticModifier;
    private final JApiAttribute<SyntheticAttribute> syntheticAttribute;
    private final List<JApiCompatibilityChange> compatibilityChanges = new LinkedList<JApiCompatibilityChange>();
    private final JApiSerialVersionUid jApiSerialVersionUid;
    private final JApiClassFileFormatVersion classFileFormatVersion;
    private boolean changeCausedByClassElement = false;
    private JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus jApiJavaObjectSerializationChangeStatus = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.NOT_SERIALIZABLE;

    public JApiClass(JarArchiveComparator jarArchiveComparator, String fullyQualifiedName, Optional<CtClass> oldClass, Optional<CtClass> newClass, JApiChangeStatus changeStatus, JApiClassType classType) {
        this.jarArchiveComparator = jarArchiveComparator;
        this.options = this.jarArchiveComparator.getJarArchiveComparatorOptions();
        this.fullyQualifiedName = fullyQualifiedName;
        this.newClass = newClass;
        this.oldClass = oldClass;
        this.classType = classType;
        this.superclass = this.extractSuperclass(oldClass, newClass);
        this.computeMethodChanges(this, oldClass, newClass);
        this.computeInterfaceChanges(this.interfaces, oldClass, newClass);
        this.computeFieldChanges(this.fields, oldClass, newClass);
        this.computeAnnotationChanges(this.annotations, oldClass, newClass);
        this.accessModifier = this.extractAccessModifier(oldClass, newClass);
        this.finalModifier = this.extractFinalModifier(oldClass, newClass);
        this.staticModifier = this.extractStaticModifier(oldClass, newClass);
        this.abstractModifier = this.extractAbstractModifier(oldClass, newClass);
        this.syntheticModifier = this.extractSyntheticModifier(oldClass, newClass);
        this.syntheticAttribute = this.extractSyntheticAttribute(oldClass, newClass);
        this.jApiSerialVersionUid = JavaObjectSerializationCompatibility.extractSerialVersionUid(this.options, jarArchiveComparator, oldClass, newClass);
        this.classFileFormatVersion = this.extractClassFileFormatVersion(oldClass, newClass);
        this.changeStatus = this.evaluateChangeStatus(changeStatus);
    }

    private JApiClassFileFormatVersion extractClassFileFormatVersion(Optional<CtClass> oldClassOptional, Optional<CtClass> newClassOptional) {
        if (oldClassOptional.isPresent() && newClassOptional.isPresent()) {
            CtClass oldClass = oldClassOptional.get();
            CtClass newClass = newClassOptional.get();
            ClassFile classFileOld = oldClass.getClassFile();
            ClassFile classFileNew = newClass.getClassFile();
            return new JApiClassFileFormatVersion(classFileOld.getMajorVersion(), classFileOld.getMinorVersion(), classFileNew.getMajorVersion(), classFileNew.getMinorVersion());
        }
        if (oldClassOptional.isPresent()) {
            CtClass oldClass = oldClassOptional.get();
            ClassFile classFileOld = oldClass.getClassFile();
            return new JApiClassFileFormatVersion(classFileOld.getMajorVersion(), classFileOld.getMinorVersion(), -1, -1);
        }
        if (newClassOptional.isPresent()) {
            CtClass newClass = newClassOptional.get();
            ClassFile classFileNew = newClass.getClassFile();
            return new JApiClassFileFormatVersion(-1, -1, classFileNew.getMajorVersion(), classFileNew.getMinorVersion());
        }
        return new JApiClassFileFormatVersion(-1, -1, -1, -1);
    }

    private void computeAnnotationChanges(List<JApiAnnotation> annotations, Optional<CtClass> oldClassOptional, Optional<CtClass> newClassOptional) {
        AnnotationHelper.computeAnnotationChanges(annotations, oldClassOptional, newClassOptional, this.options, new AnnotationHelper.AnnotationsAttributeCallback<CtClass>(){

            @Override
            public AnnotationsAttribute getAnnotationsAttribute(CtClass ctClass) {
                return (AnnotationsAttribute)ctClass.getClassFile().getAttribute("RuntimeVisibleAnnotations");
            }
        });
    }

    private JApiAttribute<SyntheticAttribute> extractSyntheticAttribute(Optional<CtClass> oldClassOptional, Optional<CtClass> newClassOptional) {
        JApiAttribute<SyntheticAttribute> jApiAttribute = new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.UNCHANGED, Optional.of(SyntheticAttribute.SYNTHETIC), Optional.of(SyntheticAttribute.SYNTHETIC));
        if (oldClassOptional.isPresent() && newClassOptional.isPresent()) {
            CtClass oldClass = oldClassOptional.get();
            CtClass newClass = newClassOptional.get();
            byte[] attributeOldClass = oldClass.getAttribute("Synthetic");
            byte[] attributeNewClass = newClass.getAttribute("Synthetic");
            jApiAttribute = attributeOldClass != null && attributeNewClass != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.UNCHANGED, Optional.of(SyntheticAttribute.SYNTHETIC), Optional.of(SyntheticAttribute.SYNTHETIC)) : (attributeOldClass != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.MODIFIED, Optional.of(SyntheticAttribute.SYNTHETIC), Optional.of(SyntheticAttribute.NON_SYNTHETIC)) : (attributeNewClass != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.MODIFIED, Optional.of(SyntheticAttribute.NON_SYNTHETIC), Optional.of(SyntheticAttribute.SYNTHETIC)) : new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.UNCHANGED, Optional.of(SyntheticAttribute.NON_SYNTHETIC), Optional.of(SyntheticAttribute.NON_SYNTHETIC))));
        } else {
            byte[] attribute;
            CtClass ctClass;
            if (oldClassOptional.isPresent()) {
                ctClass = oldClassOptional.get();
                attribute = ctClass.getAttribute("Synthetic");
                jApiAttribute = attribute != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.REMOVED, Optional.of(SyntheticAttribute.SYNTHETIC), Optional.absent()) : new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.REMOVED, Optional.of(SyntheticAttribute.NON_SYNTHETIC), Optional.absent());
            }
            if (newClassOptional.isPresent()) {
                ctClass = newClassOptional.get();
                attribute = ctClass.getAttribute("Synthetic");
                jApiAttribute = attribute != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.NEW, Optional.absent(), Optional.of(SyntheticAttribute.SYNTHETIC)) : new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.NEW, Optional.absent(), Optional.of(SyntheticAttribute.NON_SYNTHETIC));
            }
        }
        return jApiAttribute;
    }

    private void computeFieldChanges(List<JApiField> fields, Optional<CtClass> oldClassOptional, Optional<CtClass> newClassOptional) {
        block7: {
            JApiField jApiField;
            Map<String, CtField> fieldMap;
            block6: {
                if (!oldClassOptional.isPresent() || !newClassOptional.isPresent()) break block6;
                CtClass oldClass = oldClassOptional.get();
                CtClass newClass = newClassOptional.get();
                Map<String, CtField> oldFieldsMap = this.buildFieldMap(oldClass);
                Map<String, CtField> newFieldsMap = this.buildFieldMap(newClass);
                for (CtField oldField : oldFieldsMap.values()) {
                    JApiField jApiField2;
                    String oldFieldName = oldField.getName();
                    CtField newField = newFieldsMap.get(oldFieldName);
                    if (newField != null) {
                        jApiField2 = new JApiField(this, JApiChangeStatus.UNCHANGED, Optional.of(oldField), Optional.of(newField), this.options);
                        if (!this.includeField(jApiField2)) continue;
                        fields.add(jApiField2);
                        continue;
                    }
                    jApiField2 = new JApiField(this, JApiChangeStatus.REMOVED, Optional.of(oldField), Optional.absent(), this.options);
                    if (!this.includeField(jApiField2)) continue;
                    fields.add(jApiField2);
                }
                for (CtField newField : newFieldsMap.values()) {
                    JApiField jApiField3;
                    CtField oldField = oldFieldsMap.get(newField.getName());
                    if (oldField != null || !this.includeField(jApiField3 = new JApiField(this, JApiChangeStatus.NEW, Optional.absent(), Optional.of(newField), this.options))) continue;
                    fields.add(jApiField3);
                }
                break block7;
            }
            if (oldClassOptional.isPresent()) {
                fieldMap = this.buildFieldMap(oldClassOptional.get());
                for (CtField field : fieldMap.values()) {
                    jApiField = new JApiField(this, JApiChangeStatus.REMOVED, Optional.of(field), Optional.absent(), this.options);
                    if (!this.includeField(jApiField)) continue;
                    fields.add(jApiField);
                }
            }
            if (!newClassOptional.isPresent()) break block7;
            fieldMap = this.buildFieldMap(newClassOptional.get());
            for (CtField field : fieldMap.values()) {
                jApiField = new JApiField(this, JApiChangeStatus.NEW, Optional.absent(), Optional.of(field), this.options);
                if (!this.includeField(jApiField)) continue;
                fields.add(jApiField);
            }
        }
    }

    private boolean includeField(JApiField jApiField) {
        return ModifierHelper.matchesModifierLevel(jApiField, this.options.getAccessModifier());
    }

    private Map<String, CtField> buildFieldMap(CtClass ctClass) {
        CtField[] declaredFields;
        HashMap<String, CtField> fieldMap = new HashMap<String, CtField>();
        for (CtField field : declaredFields = ctClass.getDeclaredFields()) {
            if (!this.options.getFilters().includeField(field)) continue;
            String name = field.getName();
            fieldMap.put(name, field);
        }
        return fieldMap;
    }

    private JApiSuperclass extractSuperclass(Optional<CtClass> oldClassOptional, Optional<CtClass> newClassOptional) {
        JApiSuperclass retVal = new JApiSuperclass(this, Optional.absent(), Optional.absent(), JApiChangeStatus.UNCHANGED, this.jarArchiveComparator);
        if (oldClassOptional.isPresent() && newClassOptional.isPresent()) {
            String nameNew;
            String nameOld;
            CtClass oldClass = oldClassOptional.get();
            CtClass newClass = newClassOptional.get();
            Optional<CtClass> superclassOldOptional = this.getSuperclass(oldClass);
            Optional<CtClass> superclassNewOptional = this.getSuperclass(newClass);
            retVal = superclassOldOptional.isPresent() && superclassNewOptional.isPresent() ? new JApiSuperclass(this, superclassOldOptional, superclassNewOptional, (nameOld = superclassOldOptional.get().getName()).equals(nameNew = superclassNewOptional.get().getName()) ? JApiChangeStatus.UNCHANGED : JApiChangeStatus.MODIFIED, this.jarArchiveComparator) : (superclassOldOptional.isPresent() ? new JApiSuperclass(this, superclassOldOptional, superclassNewOptional, JApiChangeStatus.REMOVED, this.jarArchiveComparator) : (superclassNewOptional.isPresent() ? new JApiSuperclass(this, superclassOldOptional, superclassNewOptional, JApiChangeStatus.NEW, this.jarArchiveComparator) : new JApiSuperclass(this, superclassOldOptional, superclassNewOptional, JApiChangeStatus.UNCHANGED, this.jarArchiveComparator)));
        } else if (oldClassOptional.isPresent()) {
            Optional<CtClass> superclassOldOptional = this.getSuperclass(oldClassOptional.get());
            retVal = superclassOldOptional.isPresent() ? new JApiSuperclass(this, superclassOldOptional, Optional.absent(), JApiChangeStatus.REMOVED, this.jarArchiveComparator) : new JApiSuperclass(this, Optional.absent(), Optional.absent(), JApiChangeStatus.UNCHANGED, this.jarArchiveComparator);
        } else if (newClassOptional.isPresent()) {
            Optional<CtClass> superclassNewOptional = this.getSuperclass(newClassOptional.get());
            retVal = superclassNewOptional.isPresent() ? new JApiSuperclass(this, Optional.absent(), superclassNewOptional, JApiChangeStatus.NEW, this.jarArchiveComparator) : new JApiSuperclass(this, Optional.absent(), Optional.absent(), JApiChangeStatus.UNCHANGED, this.jarArchiveComparator);
        }
        retVal.setJApiClass(this);
        return retVal;
    }

    private Optional<CtClass> getSuperclass(CtClass ctClass) {
        try {
            CtClass superClass = ctClass.getSuperclass();
            return Optional.fromNullable(superClass);
        }
        catch (NotFoundException e) {
            if (this.options.getIgnoreMissingClasses().ignoreClass(e.getMessage())) {
                return Optional.absent();
            }
            throw JApiCmpException.forClassLoading((Exception)((Object)e), e.getMessage(), this.jarArchiveComparator);
        }
    }

    private void computeInterfaceChanges(List<JApiImplementedInterface> interfacesArg, Optional<CtClass> oldClassOptional, Optional<CtClass> newClassOptional) {
        block6: {
            block7: {
                block5: {
                    JApiImplementedInterface jApiClass;
                    CtClass ctClassFound;
                    if (!oldClassOptional.isPresent() || !newClassOptional.isPresent()) break block5;
                    CtClass oldClass = oldClassOptional.get();
                    CtClass newClass = newClassOptional.get();
                    Map<String, CtClass> interfaceMapOldClass = this.buildInterfaceMap(oldClass, JarArchiveComparator.ArchiveType.OLD);
                    Map<String, CtClass> interfaceMapNewClass = this.buildInterfaceMap(newClass, JarArchiveComparator.ArchiveType.NEW);
                    for (CtClass oldInterface : interfaceMapOldClass.values()) {
                        ctClassFound = interfaceMapNewClass.get(oldInterface.getName());
                        if (ctClassFound != null) {
                            jApiClass = new JApiImplementedInterface(oldInterface, oldInterface.getName(), JApiChangeStatus.UNCHANGED);
                            interfacesArg.add(jApiClass);
                            continue;
                        }
                        jApiClass = new JApiImplementedInterface(oldInterface, oldInterface.getName(), JApiChangeStatus.REMOVED);
                        interfacesArg.add(jApiClass);
                    }
                    for (CtClass newInterface : interfaceMapNewClass.values()) {
                        ctClassFound = interfaceMapOldClass.get(newInterface.getName());
                        if (ctClassFound != null) continue;
                        jApiClass = new JApiImplementedInterface(newInterface, newInterface.getName(), JApiChangeStatus.NEW);
                        interfacesArg.add(jApiClass);
                    }
                    break block6;
                }
                if (!oldClassOptional.isPresent()) break block7;
                Map<String, CtClass> interfaceMap = this.buildInterfaceMap(oldClassOptional.get(), JarArchiveComparator.ArchiveType.OLD);
                for (CtClass ctClass : interfaceMap.values()) {
                    JApiImplementedInterface jApiClass = new JApiImplementedInterface(ctClass, ctClass.getName(), JApiChangeStatus.REMOVED);
                    interfacesArg.add(jApiClass);
                }
                break block6;
            }
            if (!newClassOptional.isPresent()) break block6;
            Map<String, CtClass> interfaceMap = this.buildInterfaceMap(newClassOptional.get(), JarArchiveComparator.ArchiveType.NEW);
            for (CtClass ctClass : interfaceMap.values()) {
                JApiImplementedInterface jApiClass = new JApiImplementedInterface(ctClass, ctClass.getName(), JApiChangeStatus.NEW);
                interfacesArg.add(jApiClass);
            }
        }
    }

    private Map<String, CtClass> buildInterfaceMap(CtClass ctClass, JarArchiveComparator.ArchiveType archiveType) {
        HashMap<String, CtClass> map = new HashMap<String, CtClass>();
        this.buildInterfaceMap(ctClass, archiveType, map);
        return map;
    }

    private void buildInterfaceMap(CtClass ctClass, JarArchiveComparator.ArchiveType archiveType, Map<String, CtClass> map) {
        block4: {
            try {
                CtClass[] interfaces;
                for (CtClass ctInterface : interfaces = ctClass.getInterfaces()) {
                    map.put(ctInterface.getName(), ctInterface);
                    this.buildInterfaceMap(archiveType, map, ctInterface);
                }
                Optional<CtClass> superClassOptional = this.getSuperclass(ctClass);
                if (superClassOptional.isPresent()) {
                    this.buildInterfaceMap(superClassOptional.get(), archiveType, map);
                }
            }
            catch (NotFoundException e) {
                if (this.options.getIgnoreMissingClasses().ignoreClass(e.getMessage())) break block4;
                throw JApiCmpException.forClassLoading((Exception)((Object)e), "Class not found: " + e.getMessage(), this.jarArchiveComparator);
            }
        }
    }

    private void buildInterfaceMap(JarArchiveComparator.ArchiveType archiveType, Map<String, CtClass> map, CtClass ctInterface) throws NotFoundException {
        Optional<CtClass> loadedInterfaceOptional = this.jarArchiveComparator.loadClass(archiveType, ctInterface.getName());
        if (loadedInterfaceOptional.isPresent()) {
            CtClass[] loadedInterfaceInterfaces;
            CtClass loadedInterface = loadedInterfaceOptional.get();
            for (CtClass additionalInterface : loadedInterfaceInterfaces = loadedInterface.getInterfaces()) {
                map.put(additionalInterface.getName(), additionalInterface);
                this.buildInterfaceMap(archiveType, map, additionalInterface);
            }
        }
    }

    private void computeMethodChanges(JApiClass jApiClass, Optional<CtClass> oldClassOptional, Optional<CtClass> newClassOptional) {
        Map<String, List<CtMethod>> oldMethodsMap = this.createMethodMap(oldClassOptional);
        Map<String, List<CtMethod>> newMethodsMap = this.createMethodMap(newClassOptional);
        this.sortMethodsIntoLists(jApiClass, oldMethodsMap, newMethodsMap);
        Map<String, CtConstructor> oldConstructorsMap = this.createConstructorMap(oldClassOptional);
        Map<String, CtConstructor> newConstructorsMap = this.createConstructorMap(newClassOptional);
        this.sortConstructorsIntoLists(jApiClass, oldConstructorsMap, newConstructorsMap);
    }

    private void sortMethodsIntoLists(JApiClass jApiClass, Map<String, List<CtMethod>> oldMethodsMap, Map<String, List<CtMethod>> newMethodsMap) {
        JApiMethod jApiMethod;
        JApiMethod jApiMethod2;
        CtMethod matchingMethod;
        Optional<CtMethod> matchingMethodOptional;
        JApiMethod jApiMethod3;
        MethodDescriptorParser methodDescriptorParser = new MethodDescriptorParser();
        for (String methodName : oldMethodsMap.keySet()) {
            List<CtMethod> oldMethodsWithSameName = oldMethodsMap.get(methodName);
            Iterator<CtMethod> oldMethodsWithSameNameIterator = oldMethodsWithSameName.iterator();
            while (oldMethodsWithSameNameIterator.hasNext()) {
                CtMethod oldMethod = oldMethodsWithSameNameIterator.next();
                methodDescriptorParser.parse(oldMethod.getSignature());
                List<CtMethod> newMethodsWithSameName = newMethodsMap.get(methodName);
                if (newMethodsWithSameName == null) {
                    jApiMethod3 = new JApiMethod(jApiClass, oldMethod.getName(), JApiChangeStatus.REMOVED, Optional.of(oldMethod), Optional.absent(), this.jarArchiveComparator);
                    this.addParametersToMethod(methodDescriptorParser, jApiMethod3);
                    if (!this.includeMethod(jApiMethod3)) continue;
                    this.methods.add(jApiMethod3);
                    continue;
                }
                matchingMethodOptional = this.findMatchingMethod(oldMethod, newMethodsWithSameName);
                if (matchingMethodOptional.isPresent()) {
                    matchingMethod = matchingMethodOptional.get();
                    jApiMethod2 = new JApiMethod(jApiClass, oldMethod.getName(), JApiChangeStatus.UNCHANGED, Optional.of(oldMethod), Optional.of(matchingMethod), this.jarArchiveComparator);
                    this.addParametersToMethod(methodDescriptorParser, jApiMethod2);
                    if (this.includeMethod(jApiMethod2)) {
                        this.methods.add(jApiMethod2);
                    }
                    oldMethodsWithSameNameIterator.remove();
                    newMethodsWithSameName.remove(matchingMethod);
                    continue;
                }
                jApiMethod = new JApiMethod(jApiClass, oldMethod.getName(), JApiChangeStatus.REMOVED, Optional.of(oldMethod), Optional.absent(), this.jarArchiveComparator);
                this.addParametersToMethod(methodDescriptorParser, jApiMethod);
                if (!this.includeMethod(jApiMethod)) continue;
                this.methods.add(jApiMethod);
            }
        }
        for (String methodName : newMethodsMap.keySet()) {
            List<CtMethod> ctMethods = newMethodsMap.get(methodName);
            for (CtMethod ctMethod : ctMethods) {
                methodDescriptorParser.parse(ctMethod.getSignature());
                List<CtMethod> methodsWithSameName = oldMethodsMap.get(ctMethod.getName());
                if (methodsWithSameName == null) {
                    jApiMethod3 = new JApiMethod(jApiClass, ctMethod.getName(), JApiChangeStatus.NEW, Optional.absent(), Optional.of(ctMethod), this.jarArchiveComparator);
                    this.addParametersToMethod(methodDescriptorParser, jApiMethod3);
                    if (!this.includeMethod(jApiMethod3)) continue;
                    this.methods.add(jApiMethod3);
                    continue;
                }
                matchingMethodOptional = this.findMatchingMethod(ctMethod, methodsWithSameName);
                if (matchingMethodOptional.isPresent()) {
                    matchingMethod = matchingMethodOptional.get();
                    jApiMethod2 = new JApiMethod(jApiClass, ctMethod.getName(), JApiChangeStatus.UNCHANGED, Optional.of(ctMethod), Optional.of(matchingMethod), this.jarArchiveComparator);
                    this.addParametersToMethod(methodDescriptorParser, jApiMethod2);
                    if (!this.includeMethod(jApiMethod2)) continue;
                    this.methods.add(jApiMethod2);
                    continue;
                }
                jApiMethod = new JApiMethod(jApiClass, ctMethod.getName(), JApiChangeStatus.NEW, Optional.absent(), Optional.of(ctMethod), this.jarArchiveComparator);
                this.addParametersToMethod(methodDescriptorParser, jApiMethod);
                if (!this.includeMethod(jApiMethod)) continue;
                this.methods.add(jApiMethod);
            }
        }
    }

    private Optional<CtMethod> findMatchingMethod(CtMethod method, List<CtMethod> candidates) {
        SignatureParser candidateSignatureParser;
        Optional<Object> found = Optional.absent();
        SignatureParser methodSignatureParser = new SignatureParser();
        methodSignatureParser.parse(method.getSignature());
        ArrayList<CtMethod> methodsWithSameParameters = new ArrayList<CtMethod>();
        for (CtMethod candidate : candidates) {
            boolean parameterListsEqual = true;
            List<String> probeParameters = methodSignatureParser.getParameters();
            candidateSignatureParser = new SignatureParser();
            candidateSignatureParser.parse(candidate.getSignature());
            List<String> candidateParameters = candidateSignatureParser.getParameters();
            if (probeParameters.size() != candidateParameters.size()) {
                parameterListsEqual = false;
            }
            if (parameterListsEqual) {
                for (int i = 0; i < probeParameters.size(); ++i) {
                    String candidateParameter;
                    String probeParameter = probeParameters.get(i);
                    if (probeParameter.equals(candidateParameter = candidateParameters.get(i))) continue;
                    parameterListsEqual = false;
                }
            }
            if (!parameterListsEqual) continue;
            methodsWithSameParameters.add(candidate);
        }
        if (methodsWithSameParameters.size() == 1) {
            found = Optional.of(methodsWithSameParameters.get(0));
        } else if (methodsWithSameParameters.size() > 1) {
            CtMethod methodWithSameReturnType = null;
            String probeReturnType = methodSignatureParser.getReturnType();
            for (CtMethod candidate : methodsWithSameParameters) {
                candidateSignatureParser = new SignatureParser();
                candidateSignatureParser.parse(candidate.getSignature());
                String candidateReturnType = candidateSignatureParser.getReturnType();
                if (!probeReturnType.equals(candidateReturnType)) continue;
                methodWithSameReturnType = candidate;
            }
            found = methodWithSameReturnType != null ? Optional.of(methodWithSameReturnType) : Optional.of(methodsWithSameParameters.get(0));
        }
        return found;
    }

    private boolean includeMethod(JApiMethod jApiMethod) {
        return ModifierHelper.matchesModifierLevel(jApiMethod, this.options.getAccessModifier());
    }

    private void sortConstructorsIntoLists(JApiClass jApiClass, Map<String, CtConstructor> oldConstructorsMap, Map<String, CtConstructor> newConstructorsMap) {
        JApiConstructor jApiConstructor;
        CtConstructor foundMethod;
        String longName;
        MethodDescriptorParser methodDescriptorParser = new MethodDescriptorParser();
        for (CtConstructor ctMethod : oldConstructorsMap.values()) {
            longName = ctMethod.getLongName();
            methodDescriptorParser.parse(ctMethod.getSignature());
            foundMethod = newConstructorsMap.get(longName);
            if (foundMethod == null) {
                jApiConstructor = new JApiConstructor(jApiClass, ctMethod.getName(), JApiChangeStatus.REMOVED, Optional.of(ctMethod), Optional.absent(), this.jarArchiveComparator);
                this.addParametersToMethod(methodDescriptorParser, jApiConstructor);
                if (!this.includeConstructor(jApiConstructor)) continue;
                this.constructors.add(jApiConstructor);
                continue;
            }
            jApiConstructor = new JApiConstructor(jApiClass, ctMethod.getName(), JApiChangeStatus.UNCHANGED, Optional.of(ctMethod), Optional.of(foundMethod), this.jarArchiveComparator);
            this.addParametersToMethod(methodDescriptorParser, jApiConstructor);
            if (!this.includeConstructor(jApiConstructor)) continue;
            this.constructors.add(jApiConstructor);
        }
        for (CtConstructor ctMethod : newConstructorsMap.values()) {
            longName = ctMethod.getLongName();
            methodDescriptorParser.parse(ctMethod.getSignature());
            foundMethod = oldConstructorsMap.get(longName);
            if (foundMethod != null) continue;
            jApiConstructor = new JApiConstructor(jApiClass, ctMethod.getName(), JApiChangeStatus.NEW, Optional.absent(), Optional.of(ctMethod), this.jarArchiveComparator);
            this.addParametersToMethod(methodDescriptorParser, jApiConstructor);
            if (!this.includeConstructor(jApiConstructor)) continue;
            this.constructors.add(jApiConstructor);
        }
    }

    private boolean includeConstructor(JApiConstructor jApiConstructor) {
        return ModifierHelper.matchesModifierLevel(jApiConstructor, this.options.getAccessModifier());
    }

    private void addParametersToMethod(MethodDescriptorParser methodDescriptorParser, JApiBehavior jApiMethod) {
        for (String param : methodDescriptorParser.getParameters()) {
            jApiMethod.addParameter(new JApiParameter(param));
        }
    }

    private Map<String, List<CtMethod>> createMethodMap(Optional<CtClass> ctClassOptional) {
        HashMap<String, List<CtMethod>> methods = new HashMap<String, List<CtMethod>>();
        if (ctClassOptional.isPresent()) {
            CtClass ctClass = ctClassOptional.get();
            for (CtMethod ctMethod : ctClass.getDeclaredMethods()) {
                if (!this.options.getFilters().includeBehavior((CtBehavior)ctMethod)) continue;
                String name = ctMethod.getName();
                ArrayList<CtMethod> ctMethods = (ArrayList<CtMethod>)methods.get(name);
                if (ctMethods == null) {
                    ctMethods = new ArrayList<CtMethod>();
                    methods.put(name, ctMethods);
                }
                ctMethods.add(ctMethod);
            }
        }
        return methods;
    }

    private Map<String, CtConstructor> createConstructorMap(Optional<CtClass> ctClass) {
        HashMap<String, CtConstructor> methods = new HashMap<String, CtConstructor>();
        if (ctClass.isPresent()) {
            for (CtConstructor ctConstructor : ctClass.get().getDeclaredConstructors()) {
                if (!this.options.getFilters().includeBehavior((CtBehavior)ctConstructor)) continue;
                methods.put(ctConstructor.getLongName(), ctConstructor);
            }
        }
        return methods;
    }

    private JApiChangeStatus evaluateChangeStatus(JApiChangeStatus changeStatus) {
        if (changeStatus == JApiChangeStatus.UNCHANGED) {
            if (this.staticModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.finalModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.accessModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.abstractModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.syntheticAttribute.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            for (JApiImplementedInterface implementedInterface : this.interfaces) {
                if (implementedInterface.getChangeStatus() == JApiChangeStatus.UNCHANGED) continue;
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.superclass.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            for (JApiField field : this.fields) {
                if (field.getChangeStatus() == JApiChangeStatus.UNCHANGED) continue;
                changeStatus = JApiChangeStatus.MODIFIED;
                this.changeCausedByClassElement = true;
            }
            for (JApiMethod method : this.methods) {
                if (method.getChangeStatus() == JApiChangeStatus.UNCHANGED) continue;
                changeStatus = JApiChangeStatus.MODIFIED;
                this.changeCausedByClassElement = true;
            }
            for (JApiConstructor constructor : this.constructors) {
                if (constructor.getChangeStatus() == JApiChangeStatus.UNCHANGED) continue;
                changeStatus = JApiChangeStatus.MODIFIED;
                this.changeCausedByClassElement = true;
            }
        }
        return changeStatus;
    }

    private JApiModifier<StaticModifier> extractStaticModifier(Optional<CtClass> oldClassOptional, Optional<CtClass> newClassOptional) {
        return ModifierHelper.extractModifierFromClass(oldClassOptional, newClassOptional, new ModifierHelper.ExtractModifierFromClassCallback<StaticModifier>(){

            @Override
            public StaticModifier getModifierForOld(CtClass oldClass) {
                return Modifier.isStatic((int)oldClass.getModifiers()) ? StaticModifier.STATIC : StaticModifier.NON_STATIC;
            }

            @Override
            public StaticModifier getModifierForNew(CtClass newClass) {
                return Modifier.isStatic((int)newClass.getModifiers()) ? StaticModifier.STATIC : StaticModifier.NON_STATIC;
            }
        });
    }

    private JApiModifier<FinalModifier> extractFinalModifier(Optional<CtClass> oldClassOptional, Optional<CtClass> newClassOptional) {
        return ModifierHelper.extractModifierFromClass(oldClassOptional, newClassOptional, new ModifierHelper.ExtractModifierFromClassCallback<FinalModifier>(){

            @Override
            public FinalModifier getModifierForOld(CtClass oldClass) {
                return Modifier.isFinal((int)oldClass.getModifiers()) ? FinalModifier.FINAL : FinalModifier.NON_FINAL;
            }

            @Override
            public FinalModifier getModifierForNew(CtClass newClass) {
                return Modifier.isFinal((int)newClass.getModifiers()) ? FinalModifier.FINAL : FinalModifier.NON_FINAL;
            }
        });
    }

    private JApiModifier<AccessModifier> extractAccessModifier(Optional<CtClass> oldClassOptional, Optional<CtClass> newClassOptional) {
        return ModifierHelper.extractModifierFromClass(oldClassOptional, newClassOptional, new ModifierHelper.ExtractModifierFromClassCallback<AccessModifier>(){

            @Override
            public AccessModifier getModifierForOld(CtClass oldClass) {
                return ModifierHelper.translateToModifierLevel(oldClass.getModifiers());
            }

            @Override
            public AccessModifier getModifierForNew(CtClass newClass) {
                return ModifierHelper.translateToModifierLevel(newClass.getModifiers());
            }
        });
    }

    private JApiModifier<AbstractModifier> extractAbstractModifier(Optional<CtClass> oldClassOptional, Optional<CtClass> newClassOptional) {
        return ModifierHelper.extractModifierFromClass(oldClassOptional, newClassOptional, new ModifierHelper.ExtractModifierFromClassCallback<AbstractModifier>(){

            @Override
            public AbstractModifier getModifierForOld(CtClass oldClass) {
                return Modifier.isAbstract((int)oldClass.getModifiers()) ? AbstractModifier.ABSTRACT : AbstractModifier.NON_ABSTRACT;
            }

            @Override
            public AbstractModifier getModifierForNew(CtClass newClass) {
                return Modifier.isAbstract((int)newClass.getModifiers()) ? AbstractModifier.ABSTRACT : AbstractModifier.NON_ABSTRACT;
            }
        });
    }

    private JApiModifier<SyntheticModifier> extractSyntheticModifier(Optional<CtClass> oldClassOptional, Optional<CtClass> newClassOptional) {
        return ModifierHelper.extractModifierFromClass(oldClassOptional, newClassOptional, new ModifierHelper.ExtractModifierFromClassCallback<SyntheticModifier>(){

            @Override
            public SyntheticModifier getModifierForOld(CtClass oldClass) {
                return ModifierHelper.isSynthetic(oldClass.getModifiers()) ? SyntheticModifier.SYNTHETIC : SyntheticModifier.NON_SYNTHETIC;
            }

            @Override
            public SyntheticModifier getModifierForNew(CtClass newClass) {
                return ModifierHelper.isSynthetic(newClass.getModifiers()) ? SyntheticModifier.SYNTHETIC : SyntheticModifier.NON_SYNTHETIC;
            }
        });
    }

    @Override
    @XmlAttribute
    public JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus getJavaObjectSerializationCompatible() {
        return this.jApiJavaObjectSerializationChangeStatus;
    }

    @XmlAttribute
    public String getJavaObjectSerializationCompatibleAsString() {
        return this.jApiJavaObjectSerializationChangeStatus.getDescription();
    }

    @Override
    @XmlElement
    public JApiSerialVersionUid getSerialVersionUid() {
        return this.jApiSerialVersionUid;
    }

    void setJavaObjectSerializationCompatible(JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus jApiJavaObjectSerializationChangeStatus) {
        this.jApiJavaObjectSerializationChangeStatus = jApiJavaObjectSerializationChangeStatus;
    }

    @Override
    @XmlAttribute
    public JApiChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    @XmlAttribute
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @XmlTransient
    public Optional<CtClass> getNewClass() {
        return this.newClass;
    }

    @XmlTransient
    public Optional<CtClass> getOldClass() {
        return this.oldClass;
    }

    @Override
    @XmlElementWrapper(name="modifiers")
    @XmlElement(name="modifier")
    public List<? extends JApiModifier<? extends Enum<? extends Enum<?>>>> getModifiers() {
        return Arrays.asList(this.finalModifier, this.staticModifier, this.accessModifier, this.abstractModifier, this.syntheticModifier);
    }

    @XmlElement(name="superclass")
    public JApiSuperclass getSuperclass() {
        return this.superclass;
    }

    @XmlElementWrapper(name="interfaces")
    @XmlElement(name="interface")
    public List<JApiImplementedInterface> getInterfaces() {
        return this.interfaces;
    }

    @XmlElementWrapper(name="constructors")
    @XmlElement(name="constructor")
    public List<JApiConstructor> getConstructors() {
        return this.constructors;
    }

    @XmlElementWrapper(name="methods")
    @XmlElement(name="method")
    public List<JApiMethod> getMethods() {
        return this.methods;
    }

    @XmlElementWrapper(name="fields")
    @XmlElement(name="field")
    public List<JApiField> getFields() {
        return this.fields;
    }

    @XmlElement(name="classType")
    public JApiClassType getClassType() {
        return this.classType;
    }

    @Override
    @XmlTransient
    public JApiModifier<FinalModifier> getFinalModifier() {
        return this.finalModifier;
    }

    @Override
    @XmlTransient
    public JApiModifier<StaticModifier> getStaticModifier() {
        return this.staticModifier;
    }

    @Override
    @XmlTransient
    public JApiModifier<AccessModifier> getAccessModifier() {
        return this.accessModifier;
    }

    @Override
    @XmlTransient
    public JApiModifier<AbstractModifier> getAbstractModifier() {
        return this.abstractModifier;
    }

    @Override
    @XmlTransient
    public JApiModifier<SyntheticModifier> getSyntheticModifier() {
        return this.syntheticModifier;
    }

    @Override
    @XmlTransient
    public JApiAttribute<SyntheticAttribute> getSyntheticAttribute() {
        return this.syntheticAttribute;
    }

    @XmlElementWrapper(name="attributes")
    @XmlElement(name="attribute")
    public List<JApiAttribute<? extends Enum<?>>> getAttributes() {
        ArrayList list = new ArrayList();
        list.add(this.syntheticAttribute);
        return list;
    }

    @Override
    @XmlAttribute
    public boolean isBinaryCompatible() {
        boolean binaryCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isBinaryCompatible()) continue;
            binaryCompatible = false;
            break;
        }
        if (binaryCompatible) {
            for (JApiField field : this.fields) {
                if (field.isBinaryCompatible()) continue;
                binaryCompatible = false;
                break;
            }
        }
        if (binaryCompatible) {
            for (JApiMethod method : this.methods) {
                if (method.isBinaryCompatible()) continue;
                binaryCompatible = false;
                break;
            }
        }
        if (binaryCompatible) {
            for (JApiConstructor constructor : this.constructors) {
                if (constructor.isBinaryCompatible()) continue;
                binaryCompatible = false;
                break;
            }
        }
        if (binaryCompatible && !this.superclass.isBinaryCompatible()) {
            binaryCompatible = false;
        }
        if (binaryCompatible) {
            for (JApiImplementedInterface anInterface : this.interfaces) {
                for (JApiCompatibilityChange change : anInterface.getCompatibilityChanges()) {
                    if (change.isBinaryCompatible()) continue;
                    binaryCompatible = false;
                    break;
                }
                if (binaryCompatible) continue;
                break;
            }
        }
        return binaryCompatible;
    }

    @Override
    @XmlAttribute
    public boolean isSourceCompatible() {
        boolean sourceCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isSourceCompatible()) continue;
            sourceCompatible = false;
            break;
        }
        if (sourceCompatible) {
            for (JApiField field : this.fields) {
                if (field.isSourceCompatible()) continue;
                sourceCompatible = false;
                break;
            }
        }
        if (sourceCompatible) {
            for (JApiMethod method : this.methods) {
                if (method.isSourceCompatible()) continue;
                sourceCompatible = false;
                break;
            }
        }
        if (sourceCompatible) {
            for (JApiConstructor constructor : this.constructors) {
                if (constructor.isSourceCompatible()) continue;
                sourceCompatible = false;
                break;
            }
        }
        if (sourceCompatible && !this.superclass.isSourceCompatible()) {
            sourceCompatible = false;
        }
        if (sourceCompatible) {
            for (JApiImplementedInterface anInterface : this.interfaces) {
                for (JApiCompatibilityChange change : anInterface.getCompatibilityChanges()) {
                    if (change.isSourceCompatible()) continue;
                    sourceCompatible = false;
                    break;
                }
                if (sourceCompatible) continue;
                break;
            }
        }
        return sourceCompatible;
    }

    @Override
    @XmlElementWrapper(name="annotations")
    @XmlElement(name="annotation")
    public List<JApiAnnotation> getAnnotations() {
        return this.annotations;
    }

    @XmlTransient
    public boolean isChangeCausedByClassElement() {
        return this.changeCausedByClassElement;
    }

    @Override
    @XmlElementWrapper(name="compatibilityChanges")
    @XmlElement(name="compatibilityChange")
    public List<JApiCompatibilityChange> getCompatibilityChanges() {
        return this.compatibilityChanges;
    }

    @XmlElement(name="classFileFormatVersion")
    public JApiClassFileFormatVersion getClassFileFormatVersion() {
        return this.classFileFormatVersion;
    }

    public String toString() {
        return "JApiClass [fullyQualifiedName=" + this.fullyQualifiedName + ", changeStatus=" + (Object)((Object)this.changeStatus) + ", compatibilityChanges=" + this.compatibilityChanges + "]";
    }
}

