/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.model.JApiAnnotationElementValue;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiHasChangeStatus;
import japicmp.util.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

public class JApiAnnotationElement
implements JApiHasChangeStatus,
JApiCompatibility {
    private final String name;
    private final Optional<MemberValue> oldValue;
    private final Optional<MemberValue> newValue;
    private final JApiChangeStatus changeStatus;

    public JApiAnnotationElement(String name, Optional<MemberValue> oldValue, Optional<MemberValue> newValue, JApiChangeStatus changeStatus) {
        this.name = name;
        this.oldValue = oldValue;
        this.newValue = newValue;
        this.changeStatus = this.evaluateChangeStatus(changeStatus);
    }

    public String toString() {
        return "JApiAnnotationElement [name=" + this.name + ", oldValue=" + this.oldValue + ", newValue=" + this.newValue + ", changeStatus=" + (Object)((Object)this.changeStatus) + ", compatibilityChanges=" + this.getCompatibilityChanges() + "]";
    }

    private JApiChangeStatus evaluateChangeStatus(JApiChangeStatus changeStatus) {
        if (changeStatus == JApiChangeStatus.UNCHANGED) {
            if (this.oldValue.isPresent() && this.newValue.isPresent()) {
                MemberValue memberValueOld = this.oldValue.get();
                MemberValue memberValueNew = this.newValue.get();
                if (!JApiAnnotationElement.getMemberValue(memberValueOld).equals(JApiAnnotationElement.getMemberValue(memberValueNew))) {
                    changeStatus = JApiChangeStatus.MODIFIED;
                }
            } else if (!this.oldValue.isPresent() && this.newValue.isPresent()) {
                changeStatus = JApiChangeStatus.NEW;
            } else if (this.oldValue.isPresent() && !this.newValue.isPresent()) {
                changeStatus = JApiChangeStatus.REMOVED;
            }
        }
        return changeStatus;
    }

    static JApiAnnotationElementValue getMemberValue(MemberValue memberValue) {
        if (memberValue instanceof DoubleMemberValue) {
            DoubleMemberValue value = (DoubleMemberValue)memberValue;
            return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.Double, value.getValue(), Double.class.getName());
        }
        if (memberValue instanceof CharMemberValue) {
            CharMemberValue value = (CharMemberValue)memberValue;
            return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.Char, Character.valueOf(value.getValue()), Character.class.getName());
        }
        if (memberValue instanceof LongMemberValue) {
            LongMemberValue value = (LongMemberValue)memberValue;
            return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.Long, value.getValue(), Long.class.getName());
        }
        if (memberValue instanceof IntegerMemberValue) {
            IntegerMemberValue value = (IntegerMemberValue)memberValue;
            return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.Integer, value.getValue(), Integer.class.getName());
        }
        if (memberValue instanceof FloatMemberValue) {
            FloatMemberValue value = (FloatMemberValue)memberValue;
            return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.Float, Float.valueOf(value.getValue()), Float.class.getName());
        }
        if (memberValue instanceof AnnotationMemberValue) {
            AnnotationMemberValue value = (AnnotationMemberValue)memberValue;
            Annotation annotation = value.getValue();
            return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.Annotation, annotation, annotation.getTypeName());
        }
        if (memberValue instanceof ClassMemberValue) {
            ClassMemberValue value = (ClassMemberValue)memberValue;
            return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.Class, value.getValue(), value.getValue());
        }
        if (memberValue instanceof ByteMemberValue) {
            ByteMemberValue value = (ByteMemberValue)memberValue;
            return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.Byte, value.getValue(), Byte.class.getName());
        }
        if (memberValue instanceof EnumMemberValue) {
            EnumMemberValue value = (EnumMemberValue)memberValue;
            String type = value.getType();
            return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.Enum, value.getValue(), type);
        }
        if (memberValue instanceof ArrayMemberValue) {
            ArrayMemberValue value = (ArrayMemberValue)memberValue;
            return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.Array, value.getValue(), "[]");
        }
        if (memberValue instanceof ShortMemberValue) {
            ShortMemberValue value = (ShortMemberValue)memberValue;
            return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.Short, value.getValue(), Short.class.getName());
        }
        if (memberValue instanceof BooleanMemberValue) {
            BooleanMemberValue value = (BooleanMemberValue)memberValue;
            return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.Boolean, value.getValue(), Boolean.class.getName());
        }
        if (memberValue instanceof StringMemberValue) {
            StringMemberValue value = (StringMemberValue)memberValue;
            return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.String, value.getValue(), String.class.getName());
        }
        return new JApiAnnotationElementValue(JApiAnnotationElementValue.Type.UnsupportedType, "n.a.", "n.a.");
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    @XmlTransient
    public Optional<MemberValue> getOldValue() {
        return this.oldValue;
    }

    @XmlTransient
    public Optional<MemberValue> getNewValue() {
        return this.newValue;
    }

    @Override
    @XmlAttribute(name="changeStatus")
    public JApiChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    @XmlElementWrapper(name="oldElementValues")
    @XmlElement(name="oldElementValue")
    public List<JApiAnnotationElementValue> getOldElementValues() {
        ArrayList<JApiAnnotationElementValue> values = new ArrayList<JApiAnnotationElementValue>();
        if (this.oldValue.isPresent()) {
            JApiAnnotationElementValue memberValue = JApiAnnotationElement.getMemberValue(this.oldValue.get());
            if (memberValue.getType() == JApiAnnotationElementValue.Type.Array) {
                values.addAll(memberValue.getValues());
            } else {
                values.add(memberValue);
            }
        }
        return values;
    }

    @XmlElementWrapper(name="newElementValues")
    @XmlElement(name="newElementValue")
    public List<JApiAnnotationElementValue> getNewElementValues() {
        ArrayList<JApiAnnotationElementValue> values = new ArrayList<JApiAnnotationElementValue>();
        if (this.newValue.isPresent()) {
            JApiAnnotationElementValue memberValue = JApiAnnotationElement.getMemberValue(this.newValue.get());
            if (memberValue.getType() == JApiAnnotationElementValue.Type.Array) {
                values.addAll(memberValue.getValues());
            } else {
                values.add(memberValue);
            }
        }
        return values;
    }

    @Override
    @XmlAttribute
    public boolean isBinaryCompatible() {
        return true;
    }

    @Override
    @XmlAttribute
    public boolean isSourceCompatible() {
        return true;
    }

    @Override
    @XmlElementWrapper(name="compatibilityChanges")
    @XmlElement(name="compatibilityChange")
    public List<JApiCompatibilityChange> getCompatibilityChanges() {
        return Collections.emptyList();
    }
}

