/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.model.JApiAnnotationElement;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiHasChangeStatus;
import japicmp.util.Optional;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

public class JApiAnnotation
implements JApiHasChangeStatus,
JApiCompatibility {
    private final String fullyQualifiedName;
    private final Optional<Annotation> oldAnnotation;
    private final Optional<Annotation> newAnnotation;
    private final List<JApiAnnotationElement> elements = new LinkedList<JApiAnnotationElement>();
    private final JApiChangeStatus changeStatus;

    public JApiAnnotation(String fullyQualifiedName, Optional<Annotation> oldAnnotation, Optional<Annotation> newAnnotation, JApiChangeStatus changeStatus) {
        this.fullyQualifiedName = fullyQualifiedName;
        this.oldAnnotation = oldAnnotation;
        this.newAnnotation = newAnnotation;
        this.computeElements(this.elements, oldAnnotation, newAnnotation);
        this.changeStatus = this.evaluateChangeStatus(changeStatus);
    }

    public String toString() {
        return "JApiAnnotation [fullyQualifiedName=" + this.fullyQualifiedName + ", oldAnnotation=" + this.oldAnnotation + ", newAnnotation=" + this.newAnnotation + ", changeStatus=" + (Object)((Object)this.changeStatus) + ", compatibilityChanges=" + this.getCompatibilityChanges() + "]";
    }

    private void computeElements(List<JApiAnnotationElement> elements, Optional<Annotation> oldAnnotationOptional, Optional<Annotation> newAnnotationOptional) {
        block7: {
            JApiAnnotationElement jApiAnnotationElement;
            block6: {
                JApiAnnotationElement jApiAnnotationElement2;
                Optional<MemberValue> foundOptional;
                if (!oldAnnotationOptional.isPresent() || !newAnnotationOptional.isPresent()) break block6;
                Annotation oldAnnotation = oldAnnotationOptional.get();
                Annotation newAnnotation = newAnnotationOptional.get();
                Map<String, Optional<MemberValue>> oldMemberValueMap = this.buildMemberValueMap(oldAnnotation);
                Map<String, Optional<MemberValue>> newMemberValueMap = this.buildMemberValueMap(newAnnotation);
                for (String memberName : oldMemberValueMap.keySet()) {
                    foundOptional = newMemberValueMap.get(memberName);
                    if (foundOptional == null) {
                        jApiAnnotationElement2 = new JApiAnnotationElement(memberName, oldMemberValueMap.get(memberName), Optional.absent(), JApiChangeStatus.REMOVED);
                        elements.add(jApiAnnotationElement2);
                        continue;
                    }
                    jApiAnnotationElement2 = new JApiAnnotationElement(memberName, oldMemberValueMap.get(memberName), foundOptional, JApiChangeStatus.UNCHANGED);
                    elements.add(jApiAnnotationElement2);
                }
                for (String memberName : newMemberValueMap.keySet()) {
                    foundOptional = oldMemberValueMap.get(memberName);
                    if (foundOptional != null) continue;
                    jApiAnnotationElement2 = new JApiAnnotationElement(memberName, Optional.absent(), newMemberValueMap.get(memberName), JApiChangeStatus.NEW);
                    elements.add(jApiAnnotationElement2);
                }
                break block7;
            }
            if (oldAnnotationOptional.isPresent()) {
                Annotation oldAnnotation = oldAnnotationOptional.get();
                Map<String, Optional<MemberValue>> oldMemberValueMap = this.buildMemberValueMap(oldAnnotation);
                for (String memberName : oldMemberValueMap.keySet()) {
                    jApiAnnotationElement = new JApiAnnotationElement(memberName, oldMemberValueMap.get(memberName), Optional.absent(), JApiChangeStatus.REMOVED);
                    elements.add(jApiAnnotationElement);
                }
            }
            if (!newAnnotationOptional.isPresent()) break block7;
            Annotation newAnnotation = newAnnotationOptional.get();
            Map<String, Optional<MemberValue>> newMemberValueMap = this.buildMemberValueMap(newAnnotation);
            for (String memberName : newMemberValueMap.keySet()) {
                jApiAnnotationElement = new JApiAnnotationElement(memberName, Optional.absent(), newMemberValueMap.get(memberName), JApiChangeStatus.NEW);
                elements.add(jApiAnnotationElement);
            }
        }
    }

    private Map<String, Optional<MemberValue>> buildMemberValueMap(Annotation annotation) {
        HashMap<String, Optional<MemberValue>> map = new HashMap<String, Optional<MemberValue>>();
        Set memberNames = annotation.getMemberNames();
        if (memberNames != null) {
            for (String memberName : memberNames) {
                MemberValue memberValue = annotation.getMemberValue(memberName);
                if (memberValue == null) {
                    map.put(memberName, Optional.absent());
                    continue;
                }
                map.put(memberName, Optional.of(memberValue));
            }
        }
        return map;
    }

    private JApiChangeStatus evaluateChangeStatus(JApiChangeStatus changeStatus) {
        if (changeStatus == JApiChangeStatus.UNCHANGED) {
            for (JApiAnnotationElement annotationElement : this.elements) {
                if (annotationElement.getChangeStatus() == JApiChangeStatus.UNCHANGED) continue;
                changeStatus = JApiChangeStatus.MODIFIED;
            }
        }
        return changeStatus;
    }

    @Override
    @XmlAttribute(name="changeStatus")
    public JApiChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    @XmlAttribute(name="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @XmlTransient
    public Optional<Annotation> getOldAnnotation() {
        return this.oldAnnotation;
    }

    @XmlTransient
    public Optional<Annotation> getNewAnnotation() {
        return this.newAnnotation;
    }

    @XmlElementWrapper(name="elements")
    @XmlElement(name="element")
    public List<JApiAnnotationElement> getElements() {
        return this.elements;
    }

    @Override
    @XmlAttribute
    public boolean isBinaryCompatible() {
        return true;
    }

    @Override
    @XmlAttribute
    public boolean isSourceCompatible() {
        return true;
    }

    @Override
    @XmlElementWrapper(name="compatibilityChanges")
    @XmlElement(name="compatibilityChange")
    public List<JApiCompatibilityChange> getCompatibilityChanges() {
        return Collections.emptyList();
    }
}

