/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.cache;

import com.github.pagehelper.cache.Cache;
import com.github.pagehelper.util.StringUtil;
import com.google.common.cache.CacheBuilder;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class GuavaCache<K, V>
implements Cache<K, V> {
    private final com.google.common.cache.Cache<K, V> CACHE;

    public GuavaCache(Properties properties, String prefix) {
        String initialCapacity;
        String expireAfterWrite;
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        String maximumSize = properties.getProperty(prefix + ".maximumSize");
        if (StringUtil.isNotEmpty(maximumSize)) {
            cacheBuilder.maximumSize(Long.parseLong(maximumSize));
        } else {
            cacheBuilder.maximumSize(1000L);
        }
        String expireAfterAccess = properties.getProperty(prefix + ".expireAfterAccess");
        if (StringUtil.isNotEmpty(expireAfterAccess)) {
            cacheBuilder.expireAfterAccess(Long.parseLong(expireAfterAccess), TimeUnit.MILLISECONDS);
        }
        if (StringUtil.isNotEmpty(expireAfterWrite = properties.getProperty(prefix + ".expireAfterWrite"))) {
            cacheBuilder.expireAfterWrite(Long.parseLong(expireAfterWrite), TimeUnit.MILLISECONDS);
        }
        if (StringUtil.isNotEmpty(initialCapacity = properties.getProperty(prefix + ".initialCapacity"))) {
            cacheBuilder.initialCapacity(Integer.parseInt(initialCapacity));
        }
        this.CACHE = cacheBuilder.build();
    }

    @Override
    public V get(K key) {
        return (V)this.CACHE.getIfPresent(key);
    }

    @Override
    public void put(K key, V value) {
        this.CACHE.put(key, value);
    }
}

