/*
 * Decompiled with CFR 0.152.
 */
package com.github.javafaker.service;

import java.util.Random;

public class RandomService {
    private static final Random SHARED_RANDOM = new Random();
    private final Random random;

    public RandomService() {
        this(SHARED_RANDOM);
    }

    public RandomService(Random random) {
        this.random = random != null ? random : SHARED_RANDOM;
    }

    public int nextInt(int n) {
        return this.random.nextInt(n);
    }

    public long nextLong() {
        return this.random.nextLong();
    }

    public long nextLong(long n) {
        long val;
        long randomLong;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        while ((bits = (randomLong = this.random.nextLong()) << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    public double nextDouble() {
        return this.random.nextDouble();
    }

    public Boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    public Integer nextInt(int min, int max) {
        return this.random.nextInt(max - min + 1) + min;
    }
}

